/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.dromara.hutool.core.collection.iter.ComputeIter;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.ReaderWrapper;
import org.dromara.hutool.core.text.CharUtil;
import org.dromara.hutool.core.text.StrUtil;

public class LineReader
extends ReaderWrapper
implements Iterable<String> {
    public LineReader(InputStream in, Charset charset) {
        this(IoUtil.toReader(in, charset));
    }

    public LineReader(Reader reader) {
        super(IoUtil.toBuffered(reader));
    }

    public String readLine() throws IOException {
        int c;
        StringBuilder str = null;
        boolean precedingBackslash = false;
        while ((c = this.read()) > 0) {
            if (null == str) {
                str = StrUtil.builder(1024);
            }
            if (92 == c) {
                if (!precedingBackslash) {
                    precedingBackslash = true;
                    continue;
                }
                precedingBackslash = false;
            } else if (precedingBackslash) {
                if (CharUtil.isBlankChar(c)) continue;
                precedingBackslash = false;
            } else if (10 == c) {
                int lastIndex = str.length() - 1;
                if (lastIndex < 0 || '\r' != str.charAt(lastIndex)) break;
                str.deleteCharAt(lastIndex);
                break;
            }
            str.append((char)c);
        }
        return StrUtil.toStringOrNull(str);
    }

    @Override
    public Iterator<String> iterator() {
        return new ComputeIter<String>(){

            @Override
            protected String computeNext() {
                try {
                    return LineReader.this.readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

