/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.watch;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.file.PathUtil;
import org.dromara.hutool.core.io.watch.WatchException;
import org.dromara.hutool.core.io.watch.WatchKind;
import org.dromara.hutool.core.io.watch.WatchServer;
import org.dromara.hutool.core.io.watch.Watcher;
import org.dromara.hutool.core.net.url.URLUtil;
import org.dromara.hutool.core.text.StrUtil;

public class WatchMonitor
extends WatchServer {
    private static final long serialVersionUID = 1L;
    private Path path;
    private int maxDepth;
    private Path filePath;
    private Watcher watcher;

    public static WatchMonitor of(URL url, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(url, 0, events);
    }

    public static WatchMonitor of(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(URLUtil.toURI(url), maxDepth, events);
    }

    public static WatchMonitor of(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(uri, 0, events);
    }

    public static WatchMonitor of(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor of(File file, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(file, 0, events);
    }

    public static WatchMonitor of(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor of(String path, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(path, 0, events);
    }

    public static WatchMonitor of(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor of(Path path, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(path, 0, events);
    }

    public static WatchMonitor of(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor ofAll(URI uri, Watcher watcher) {
        return WatchMonitor.ofAll(Paths.get(uri), watcher);
    }

    public static WatchMonitor ofAll(URL url, Watcher watcher) {
        try {
            return WatchMonitor.ofAll(Paths.get(url.toURI()), watcher);
        }
        catch (URISyntaxException e) {
            throw new WatchException(e);
        }
    }

    public static WatchMonitor ofAll(File file, Watcher watcher) {
        return WatchMonitor.ofAll(file.toPath(), watcher);
    }

    public static WatchMonitor ofAll(String path, Watcher watcher) {
        return WatchMonitor.ofAll(Paths.get(path, new String[0]), watcher);
    }

    public static WatchMonitor ofAll(Path path, Watcher watcher) {
        WatchMonitor watchMonitor = WatchMonitor.of(path, WatchKind.ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public WatchMonitor(File file, WatchEvent.Kind<?> ... events) {
        this(file.toPath(), events);
    }

    public WatchMonitor(String path, WatchEvent.Kind<?> ... events) {
        this(Paths.get(path, new String[0]), events);
    }

    public WatchMonitor(Path path, WatchEvent.Kind<?> ... events) {
        this(path, 0, events);
    }

    public WatchMonitor(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        this.path = path;
        this.maxDepth = maxDepth;
        this.events = events;
        this.init();
    }

    @Override
    public void init() throws WatchException {
        if (!PathUtil.exists(this.path, false)) {
            String lastPathEleStr;
            Path lastPathEle = FileUtil.getLastPathEle(this.path);
            if (null != lastPathEle && StrUtil.contains((CharSequence)(lastPathEleStr = lastPathEle.toString()), '.') && !StrUtil.endWithIgnoreCase(lastPathEleStr, ".d")) {
                this.filePath = this.path;
                this.path = this.filePath.getParent();
            }
            PathUtil.mkdir(this.path);
        } else if (PathUtil.isFile(this.path, false)) {
            this.filePath = this.path;
            this.path = this.filePath.getParent();
        }
        super.init();
    }

    public WatchMonitor setWatcher(Watcher watcher) {
        this.watcher = watcher;
        return this;
    }

    @Override
    public void run() {
        this.watch();
    }

    public void watch() {
        this.watch(this.watcher);
    }

    public void watch(Watcher watcher) throws WatchException {
        if (this.isClosed) {
            throw new WatchException("Watch Monitor is closed !");
        }
        this.registerPath();
        while (!this.isClosed) {
            this.doTakeAndWatch(watcher);
        }
    }

    public WatchMonitor setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    private void doTakeAndWatch(Watcher watcher) {
        super.watch(watcher, (WatchEvent<?> watchEvent) -> null == this.filePath || this.filePath.endsWith(watchEvent.context().toString()));
    }

    private void registerPath() {
        this.registerPath(this.path, null != this.filePath ? 0 : this.maxDepth);
    }
}

