/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.tuple;

import java.io.Serializable;
import java.util.Objects;
import org.dromara.hutool.core.exception.CloneException;

public class Triple<L, M, R>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected L left;
    protected M middle;
    protected R right;

    public static <L, M, R> Triple<L, M, R> of(L left, M middle, R right) {
        return new Triple<L, M, R>(left, middle, right);
    }

    public Triple(L left, M middle, R right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public M getMiddle() {
        return this.middle;
    }

    public R getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Triple) {
            Triple triple = (Triple)o;
            return Objects.equals(this.getLeft(), triple.getLeft()) && Objects.equals(this.getMiddle(), triple.getMiddle()) && Objects.equals(this.getRight(), triple.getRight());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getLeft()) ^ Objects.hashCode(this.getMiddle()) ^ Objects.hashCode(this.getRight());
    }

    public String toString() {
        return "Triple {left=" + this.getLeft() + ", middle=" + this.getMiddle() + ", right=" + this.getRight() + '}';
    }

    public Triple<L, M, R> clone() {
        try {
            return (Triple)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }
}

