/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.tree;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.tree.Node;
import org.dromara.hutool.core.tree.TreeNodeConfig;
import org.dromara.hutool.core.tree.TreeUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class MapTree<T>
extends LinkedHashMap<String, Object>
implements Node<T> {
    private static final long serialVersionUID = 1L;
    private final TreeNodeConfig treeNodeConfig;
    private MapTree<T> parent;

    public MapTree() {
        this((TreeNodeConfig)null);
    }

    public MapTree(TreeNodeConfig treeNodeConfig) {
        this.treeNodeConfig = ObjUtil.defaultIfNull(treeNodeConfig, TreeNodeConfig.DEFAULT_CONFIG);
    }

    public TreeNodeConfig getConfig() {
        return this.treeNodeConfig;
    }

    public MapTree<T> getParent() {
        return this.parent;
    }

    public MapTree<T> getNode(T id) {
        return TreeUtil.getNode(this, id);
    }

    public List<CharSequence> getParentsName(T id, boolean includeCurrentNode) {
        return TreeUtil.getParentsName(this.getNode(id), includeCurrentNode);
    }

    public List<CharSequence> getParentsName(boolean includeCurrentNode) {
        return TreeUtil.getParentsName(this, includeCurrentNode);
    }

    public MapTree<T> setParent(MapTree<T> parent) {
        this.parent = parent;
        if (null != parent) {
            this.setParentId((Object)parent.getId());
        }
        return this;
    }

    @Override
    public T getId() {
        return (T)this.get(this.treeNodeConfig.getIdKey());
    }

    @Override
    public MapTree<T> setId(T id) {
        this.put(this.treeNodeConfig.getIdKey(), id);
        return this;
    }

    @Override
    public T getParentId() {
        return (T)this.get(this.treeNodeConfig.getParentIdKey());
    }

    @Override
    public MapTree<T> setParentId(T parentId) {
        this.put(this.treeNodeConfig.getParentIdKey(), parentId);
        return this;
    }

    @Override
    public CharSequence getName() {
        return (CharSequence)this.get(this.treeNodeConfig.getNameKey());
    }

    @Override
    public MapTree<T> setName(CharSequence name) {
        this.put(this.treeNodeConfig.getNameKey(), name);
        return this;
    }

    @Override
    public Comparable<?> getWeight() {
        return (Comparable)this.get(this.treeNodeConfig.getWeightKey());
    }

    @Override
    public MapTree<T> setWeight(Comparable<?> weight) {
        this.put(this.treeNodeConfig.getWeightKey(), weight);
        return this;
    }

    public List<MapTree<T>> getChildren() {
        return (List)this.get(this.treeNodeConfig.getChildrenKey());
    }

    public boolean hasChild() {
        return CollUtil.isNotEmpty(this.getChildren());
    }

    public void walk(Consumer<MapTree<T>> consumer) {
        this.walk(consumer, false);
    }

    public void walk(Consumer<MapTree<T>> consumer, boolean broadFirst) {
        if (broadFirst) {
            LinkedList<MapTree> queue = new LinkedList<MapTree>();
            queue.offer(this);
            while (!queue.isEmpty()) {
                MapTree node = (MapTree)queue.poll();
                consumer.accept(node);
                List<MapTree<MapTree>> children = node.getChildren();
                if (!CollUtil.isNotEmpty(children)) continue;
                children.forEach(queue::offer);
            }
        } else {
            Stack<MapTree> stack = new Stack<MapTree>();
            stack.add(this);
            while (!stack.isEmpty()) {
                MapTree node = (MapTree)stack.pop();
                consumer.accept(node);
                List<MapTree<MapTree>> children = node.getChildren();
                if (!CollUtil.isNotEmpty(children)) continue;
                children.forEach(stack::push);
            }
        }
    }

    public MapTree<T> filterNew(Predicate<MapTree<T>> predicate) {
        return this.cloneTree().filter(predicate);
    }

    public MapTree<T> filter(Predicate<MapTree<T>> predicate) {
        if (null == predicate || predicate.test(this)) {
            return this;
        }
        List<MapTree<T>> children = this.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            ArrayList<MapTree<T>> filteredChildren = new ArrayList<MapTree<T>>(children.size());
            for (MapTree<MapTree<MapTree>> mapTree : children) {
                MapTree<T> filteredChild = mapTree.filter(predicate);
                if (null == filteredChild) continue;
                filteredChildren.add(filteredChild);
            }
            if (CollUtil.isNotEmpty(filteredChildren)) {
                return this.setChildren(filteredChildren);
            }
            this.setChildren(null);
        }
        return null;
    }

    public MapTree<T> setChildren(List<MapTree<T>> children) {
        if (null == children) {
            this.remove(this.treeNodeConfig.getChildrenKey());
        }
        this.put(this.treeNodeConfig.getChildrenKey(), children);
        return this;
    }

    @SafeVarargs
    public final MapTree<T> addChildren(MapTree<T> ... children) {
        if (ArrayUtil.isNotEmpty(children)) {
            List<MapTree<T>> childrenList = this.getChildren();
            if (null == childrenList) {
                childrenList = new ArrayList<MapTree<T>>();
                this.setChildren(childrenList);
            }
            for (MapTree<T> child : children) {
                child.setParent(this);
                childrenList.add(child);
            }
        }
        return this;
    }

    public void putExtra(String key, Object value) {
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.put(key, value);
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        MapTree.printTree(this, new PrintWriter(stringWriter), 0);
        return stringWriter.toString();
    }

    public MapTree<T> cloneTree() {
        MapTree result = ObjUtil.clone(this);
        result.setChildren(this.cloneChildren());
        return result;
    }

    private List<MapTree<T>> cloneChildren() {
        List<MapTree<MapTree>> children = this.getChildren();
        if (null == children) {
            return null;
        }
        ArrayList newChildren = new ArrayList(children.size());
        children.forEach((? super T t) -> newChildren.add(t.cloneTree()));
        return newChildren;
    }

    private static void printTree(MapTree<?> tree, PrintWriter writer, int intent) {
        writer.println(StrUtil.format("{}{}[{}]", StrUtil.repeat(' ', intent), tree.getName(), tree.getId()));
        writer.flush();
        List<MapTree<?>> children = tree.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            for (MapTree<?> child : children) {
                MapTree.printTree(child, writer, intent + 2);
            }
        }
    }
}

