/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.symmetric;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.codec.HexUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.RandomUtil;
import org.dromara.hutool.crypto.CipherMode;
import org.dromara.hutool.crypto.CipherWrapper;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.Padding;
import org.dromara.hutool.crypto.openssl.OpenSSLSaltParser;
import org.dromara.hutool.crypto.openssl.SaltMagic;
import org.dromara.hutool.crypto.symmetric.SymmetricAlgorithm;
import org.dromara.hutool.crypto.symmetric.SymmetricDecryptor;
import org.dromara.hutool.crypto.symmetric.SymmetricEncryptor;

public class SymmetricCrypto
implements SymmetricEncryptor,
SymmetricDecryptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private CipherWrapper cipherWrapper;
    private SecretKey secretKey;
    private boolean isZeroPadding;
    private final Lock lock = new ReentrantLock();

    public SymmetricCrypto(SymmetricAlgorithm algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, SecretKey key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(String algorithm, byte[] key) {
        this(algorithm, KeyUtil.generateKey(algorithm, key));
    }

    public SymmetricCrypto(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public SymmetricCrypto(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key);
        this.initParams(algorithm, paramsSpec);
    }

    public SymmetricCrypto init(String algorithm, SecretKey key) {
        Assert.notBlank(algorithm, "'algorithm' must be not blank !", new Object[0]);
        this.secretKey = key;
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = StrUtil.replace((CharSequence)algorithm, (CharSequence)Padding.ZeroPadding.name(), Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.cipherWrapper = new CipherWrapper(algorithm);
        return this;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipherWrapper.getRaw();
    }

    public SymmetricCrypto setParams(AlgorithmParameterSpec params) {
        this.cipherWrapper.setParams(params);
        return this;
    }

    public SymmetricCrypto setIv(IvParameterSpec iv) {
        return this.setParams(iv);
    }

    public SymmetricCrypto setIv(byte[] iv) {
        return this.setIv(new IvParameterSpec(iv));
    }

    public SymmetricCrypto setRandom(SecureRandom random) {
        this.cipherWrapper.setRandom(random);
        return this;
    }

    public SymmetricCrypto setMode(CipherMode mode) {
        return this.setMode(mode, null);
    }

    public SymmetricCrypto setMode(CipherMode mode, byte[] salt) {
        this.lock.lock();
        try {
            this.initMode(mode.getValue(), salt);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public byte[] update(byte[] data) {
        Cipher cipher = this.cipherWrapper.getRaw();
        this.lock.lock();
        try {
            byte[] byArray = cipher.update(this.paddingDataWithZero(data, cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String updateHex(byte[] data) {
        return HexUtil.encodeHexStr(this.update(data));
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.encrypt(data, null);
    }

    public byte[] encrypt(byte[] data, byte[] salt) {
        byte[] result;
        this.lock.lock();
        try {
            Cipher cipher = this.initMode(1, salt);
            result = cipher.doFinal(this.paddingDataWithZero(data, cipher.getBlockSize()));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return SaltMagic.addMagic(result, salt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void encrypt(InputStream data, OutputStream out, boolean isClose) throws IORuntimeException {
        this.lock.lock();
        CipherOutputStream cipherOutputStream = null;
        try {
            int remainLength;
            int blockSize;
            Cipher cipher = this.initMode(1, null);
            cipherOutputStream = new CipherOutputStream(out, cipher);
            long length = IoUtil.copy(data, cipherOutputStream);
            if (this.isZeroPadding && (blockSize = cipher.getBlockSize()) > 0 && (remainLength = (int)(length % (long)blockSize)) > 0) {
                cipherOutputStream.write(new byte[blockSize - remainLength]);
                cipherOutputStream.flush();
            }
        }
        catch (IORuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new CryptoException(e2);
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                IoUtil.closeQuietly(cipherOutputStream);
                if (!isClose) throw throwable;
                IoUtil.closeQuietly(data);
                throw throwable;
            }
        }
        this.lock.unlock();
        IoUtil.closeQuietly(cipherOutputStream);
        if (!isClose) return;
        IoUtil.closeQuietly(data);
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        byte[] decryptData;
        int blockSize;
        this.lock.lock();
        byte[] salt = SaltMagic.getSalt(bytes);
        try {
            Cipher cipher = this.initMode(2, salt);
            blockSize = cipher.getBlockSize();
            decryptData = cipher.doFinal(SaltMagic.getData(bytes));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding(decryptData, blockSize);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decrypt(InputStream data, OutputStream out, boolean isClose) throws IORuntimeException {
        CipherInputStream cipherInputStream;
        block7: {
            int blockSize;
            this.lock.lock();
            cipherInputStream = null;
            Cipher cipher = this.initMode(2, null);
            cipherInputStream = new CipherInputStream(data, cipher);
            if (!this.isZeroPadding || (blockSize = cipher.getBlockSize()) <= 0) break block7;
            SymmetricCrypto.copyForZeroPadding(cipherInputStream, out, blockSize);
            this.lock.unlock();
            IoUtil.closeQuietly(cipherInputStream);
            if (!isClose) return;
            IoUtil.closeQuietly(data);
            return;
        }
        try {
            IoUtil.copy(cipherInputStream, out);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
                catch (IORuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new CryptoException(e3);
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                IoUtil.closeQuietly(cipherInputStream);
                if (!isClose) throw throwable;
                IoUtil.closeQuietly(data);
                throw throwable;
            }
        }
        this.lock.unlock();
        IoUtil.closeQuietly(cipherInputStream);
        if (!isClose) return;
        IoUtil.closeQuietly(data);
        return;
    }

    private SymmetricCrypto initParams(String algorithm, AlgorithmParameterSpec paramsSpec) {
        if (null == paramsSpec) {
            byte[] iv = Opt.ofNullable(this.cipherWrapper).map(CipherWrapper::getRaw).map(Cipher::getIV).get();
            if (StrUtil.startWithIgnoreCase(algorithm, "PBE")) {
                if (null == iv) {
                    iv = RandomUtil.randomBytes(8);
                }
                paramsSpec = new PBEParameterSpec(iv, 100);
            } else if (StrUtil.startWithIgnoreCase(algorithm, "AES") && null != iv) {
                paramsSpec = new IvParameterSpec(iv);
            }
        }
        return this.setParams(paramsSpec);
    }

    private Cipher initMode(int mode, byte[] salt) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey secretKey = this.secretKey;
        if (null != salt) {
            String algorithm = this.getCipher().getAlgorithm();
            byte[][] keyAndIV = OpenSSLSaltParser.ofMd5(32, algorithm).getKeyAndIV(secretKey.getEncoded(), salt);
            secretKey = KeyUtil.generateKey(algorithm, keyAndIV[0]);
            if (ArrayUtil.isNotEmpty(keyAndIV[1])) {
                this.cipherWrapper.setParams(new IvParameterSpec(keyAndIV[1]));
            }
        }
        return this.cipherWrapper.initMode(mode, secretKey).getRaw();
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return ArrayUtil.resize(data, length + blockSize - remainLength);
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && blockSize > 0 && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return ArrayUtil.resize(data, i + 1);
        }
        return data;
    }

    private static void copyForZeroPadding(CipherInputStream in, OutputStream out, int blockSize) throws IOException {
        int i;
        int readSize;
        int n = 1;
        if (8192 > blockSize) {
            n = Math.max(n, 8192 / blockSize);
        }
        int bufSize = blockSize * n;
        byte[] preBuffer = new byte[bufSize];
        byte[] buffer = new byte[bufSize];
        boolean isFirst = true;
        int preReadSize = 0;
        while ((readSize = in.read(buffer)) != -1) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.write(preBuffer, 0, preReadSize);
            }
            ArrayUtil.copy(buffer, preBuffer, readSize);
            preReadSize = readSize;
        }
        for (i = preReadSize - 1; i >= 0 && 0 == preBuffer[i]; --i) {
        }
        out.write(preBuffer, 0, i + 1);
        out.flush();
    }
}

