/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.db.GlobalDbConfig;
import org.dromara.hutool.log.Log;
import org.dromara.hutool.log.level.Level;
import org.dromara.hutool.setting.Setting;

public final class DbUtil {
    private static final Log log = Log.get();

    public static void setShowSqlGlobal(Setting setting) {
        boolean isShowSql = Convert.toBoolean(setting.remove("showSql"), false);
        boolean isFormatSql = Convert.toBoolean(setting.remove("formatSql"), false);
        boolean isShowParams = Convert.toBoolean(setting.remove("showParams"), false);
        String sqlLevelStr = setting.remove("sqlLevel");
        if (null != sqlLevelStr) {
            sqlLevelStr = sqlLevelStr.toUpperCase();
        }
        Level level = Convert.toEnum(Level.class, sqlLevelStr, Level.DEBUG);
        log.debug("Show sql: [{}], format sql: [{}], show params: [{}], level: [{}]", new Object[]{isShowSql, isFormatSql, isShowParams, level});
        DbUtil.setShowSqlGlobal(isShowSql, isFormatSql, isShowParams, level);
    }

    public static void setShowSqlGlobal(boolean isShowSql, boolean isFormatSql, boolean isShowParams, Level level) {
        GlobalDbConfig.setShowSql(isShowSql, isFormatSql, isShowParams, level);
    }

    public static void setCaseInsensitiveGlobal(boolean caseInsensitive) {
        GlobalDbConfig.setCaseInsensitive(caseInsensitive);
    }

    public static void setReturnGeneratedKeyGlobal(boolean returnGeneratedKey) {
        GlobalDbConfig.setReturnGeneratedKey(returnGeneratedKey);
    }

    public static void setDbSettingPathGlobal(String dbSettingPath) {
        GlobalDbConfig.setDbSettingPath(dbSettingPath);
    }
}

