/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import org.dromara.hutool.core.func.SerConsumer;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.AbstractDb;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.dialect.Dialect;
import org.dromara.hutool.db.dialect.DialectFactory;
import org.dromara.hutool.db.ds.DSUtil;
import org.dromara.hutool.log.Log;

public class Session
extends AbstractDb<Session>
implements Closeable {
    private static final long serialVersionUID = 3421251905539056945L;
    private static final Log log = Log.get();

    public static Session of() {
        return new Session(DSUtil.getDS());
    }

    public static Session of(String group) {
        return new Session(DSUtil.getDS(group));
    }

    public static Session of(DataSource ds) {
        return new Session(ds);
    }

    public Session(DataSource ds) {
        this(ds, DialectFactory.getDialect(ds));
    }

    public Session(DataSource ds, String driverClassName) {
        this(ds, DialectFactory.newDialect(driverClassName));
    }

    public Session(DataSource ds, Dialect dialect) {
        super(ds, dialect);
    }

    public void beginTransaction() throws DbRuntimeException {
        Connection conn = this.getConnection();
        this.checkTransactionSupported(conn);
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public void commit() throws DbRuntimeException {
        try {
            this.getConnection().commit();
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        finally {
            try {
                this.getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public void rollback() throws DbRuntimeException {
        try {
            this.getConnection().rollback();
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        finally {
            try {
                this.getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public void quietRollback() {
        try {
            this.getConnection().rollback();
        }
        catch (Exception e) {
            log.error(e);
        }
        finally {
            try {
                this.getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public void rollback(Savepoint savepoint) throws DbRuntimeException {
        try {
            this.getConnection().rollback(savepoint);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        finally {
            try {
                this.getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public void quietRollback(Savepoint savepoint) {
        try {
            this.getConnection().rollback(savepoint);
        }
        catch (Exception e) {
            log.error(e);
        }
        finally {
            try {
                this.getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public Savepoint setSavepoint() throws DbRuntimeException {
        try {
            return this.getConnection().setSavepoint();
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.getConnection().setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws DbRuntimeException {
        try {
            if (!this.getConnection().getMetaData().supportsTransactionIsolationLevel(level)) {
                throw new DbRuntimeException(StrUtil.format("Transaction isolation [{}] not support!", level));
            }
            this.getConnection().setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public void tx(SerConsumer<Session> func) throws DbRuntimeException {
        try {
            this.beginTransaction();
            func.accept(this);
            this.commit();
        }
        catch (Throwable e) {
            this.quietRollback();
            throw new DbRuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.closeConnection(null);
    }
}

