/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.c3p0;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.util.Properties;
import javax.sql.DataSource;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.ds.AbstractDSFactory;
import org.dromara.hutool.db.ds.DSKeys;
import org.dromara.hutool.setting.Setting;
import org.dromara.hutool.setting.props.Props;

public class C3p0DSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = -6090788225842047281L;
    public static final String DS_NAME = "C3P0";

    public C3p0DSFactory() {
        this(null);
    }

    public C3p0DSFactory(Setting setting) {
        super(DS_NAME, ComboPooledDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        ComboPooledDataSource ds = new ComboPooledDataSource();
        Props connProps = new Props();
        for (String key : DSKeys.KEY_CONN_PROPS) {
            String connValue = poolSetting.getAndRemove(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            connProps.setProperty(key, connValue);
        }
        if (MapUtil.isNotEmpty(connProps)) {
            ds.setProperties((Properties)connProps);
        }
        ds.setJdbcUrl(jdbcUrl);
        try {
            ds.setDriverClass(driver);
        }
        catch (PropertyVetoException e) {
            throw new DbRuntimeException(e);
        }
        ds.setUser(user);
        ds.setPassword(pass);
        poolSetting.toBean(ds);
        return ds;
    }
}

