/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.dbcp;

import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.ds.AbstractDSFactory;
import org.dromara.hutool.db.ds.DSKeys;
import org.dromara.hutool.setting.Setting;

public class DbcpDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = -9133501414334104548L;
    public static final String DS_NAME = "commons-dbcp2";

    public DbcpDSFactory() {
        this(null);
    }

    public DbcpDSFactory(Setting setting) {
        super(DS_NAME, BasicDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(jdbcUrl);
        ds.setDriverClassName(driver);
        ds.setUsername(user);
        ds.setPassword(pass);
        for (String key : DSKeys.KEY_CONN_PROPS) {
            String connValue = poolSetting.getAndRemove(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            ds.addConnectionProperty(key, connValue);
        }
        poolSetting.toBean(ds);
        return ds;
    }
}

