/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.meta;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.dromara.hutool.db.DbRuntimeException;

public class ResultColumn {
    private final boolean autoIncrement;
    private final boolean caseSensitive;
    private final boolean searchable;
    private final boolean currency;
    private final int nullable;
    private final boolean signed;
    private final int displaySize;
    private final String label;
    private final String name;
    private final String schemaName;
    private final int precision;
    private final int scale;
    private final String tableName;
    private final String catalogName;
    private final int type;
    private final String typeName;
    private final boolean readOnly;
    private final boolean writable;
    private final boolean definitelyWritable;
    private final String className;

    public ResultColumn(ResultSetMetaData metaData, int columnIndexBase1) throws DbRuntimeException {
        try {
            this.autoIncrement = metaData.isAutoIncrement(columnIndexBase1);
            this.caseSensitive = metaData.isCaseSensitive(columnIndexBase1);
            this.searchable = metaData.isSearchable(columnIndexBase1);
            this.currency = metaData.isCurrency(columnIndexBase1);
            this.nullable = metaData.isNullable(columnIndexBase1);
            this.signed = metaData.isSigned(columnIndexBase1);
            this.displaySize = metaData.getColumnDisplaySize(columnIndexBase1);
            this.label = metaData.getColumnLabel(columnIndexBase1);
            this.name = metaData.getColumnName(columnIndexBase1);
            this.schemaName = metaData.getSchemaName(columnIndexBase1);
            this.precision = metaData.getPrecision(columnIndexBase1);
            this.scale = metaData.getScale(columnIndexBase1);
            this.tableName = metaData.getTableName(columnIndexBase1);
            this.catalogName = metaData.getCatalogName(columnIndexBase1);
            this.type = metaData.getColumnType(columnIndexBase1);
            this.typeName = metaData.getColumnTypeName(columnIndexBase1);
            this.readOnly = metaData.isReadOnly(columnIndexBase1);
            this.writable = metaData.isWritable(columnIndexBase1);
            this.definitelyWritable = metaData.isDefinitelyWritable(columnIndexBase1);
            this.className = metaData.getColumnClassName(columnIndexBase1);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public int getNullable() {
        return this.nullable;
    }

    public ColumnNullable getNullableEnum() {
        return ColumnNullable.of(this.getNullable());
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isDefinitelyWritable() {
        return this.definitelyWritable;
    }

    public String getClassName() {
        return this.className;
    }

    public static enum ColumnNullable {
        NO_NULLS(0),
        NULLABLE(1),
        UNKNOWN(2);

        final int value;

        public static ColumnNullable of(int nullable) {
            switch (nullable) {
                case 0: {
                    return NO_NULLS;
                }
                case 1: {
                    return NULLABLE;
                }
            }
            return UNKNOWN;
        }

        private ColumnNullable(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

