/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import org.dromara.hutool.db.sql.SqlFormatter;
import org.dromara.hutool.log.Log;
import org.dromara.hutool.log.level.Level;

public class SqlLog {
    public static SqlLog INSTANCE = new SqlLog();
    private static final Log log = Log.get();
    private boolean showSql;
    private boolean formatSql;
    private boolean showParams;
    private Level level = Level.DEBUG;

    public void init(boolean isShowSql, boolean isFormatSql, boolean isShowParams, Level level) {
        this.showSql = isShowSql;
        this.formatSql = isFormatSql;
        this.showParams = isShowParams;
        this.level = level;
    }

    public void log(String sql) {
        this.log(sql, null);
    }

    public void logForBatch(String sql) {
        if (this.showSql) {
            log.log(this.level, "\n[Batch SQL] -> {}", this.formatSql ? SqlFormatter.format(sql) : sql);
        }
    }

    public void log(String sql, Object paramValues) {
        if (this.showSql) {
            if (null != paramValues && this.showParams) {
                log.log(this.level, "\n[SQL] -> {}\nParams -> {}", this.formatSql ? SqlFormatter.format(sql) : sql, paramValues);
            } else {
                log.log(this.level, "\n[SQL] -> {}", this.formatSql ? SqlFormatter.format(sql) : sql);
            }
        }
    }
}

