/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.qrcode;

import com.google.zxing.DecodeHintType;
import com.google.zxing.common.BitMatrix;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.extra.qrcode.QrAsciiArt;
import org.dromara.hutool.extra.qrcode.QrConfig;
import org.dromara.hutool.extra.qrcode.QrDecoder;
import org.dromara.hutool.extra.qrcode.QrEncoder;
import org.dromara.hutool.extra.qrcode.QrImage;
import org.dromara.hutool.extra.qrcode.QrSVG;
import org.dromara.hutool.swing.img.ImgUtil;

public class QrCodeUtil {
    public static final String QR_TYPE_SVG = "svg";
    public static final String QR_TYPE_TXT = "txt";

    public static String generateAsBase64DataUri(String content, QrConfig qrConfig, String imageType) {
        BufferedImage img = QrCodeUtil.generate(content, qrConfig);
        return ImgUtil.toBase64DataUri(img, imageType);
    }

    public static byte[] generatePng(String content, int width, int height) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeUtil.generate(content, width, height, "png", out);
        return out.toByteArray();
    }

    public static byte[] generatePng(String content, QrConfig config) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeUtil.generate(content, config, "png", out);
        return out.toByteArray();
    }

    public static File generate(String content, int width, int height, File targetFile) {
        BufferedImage image = QrCodeUtil.generate(content, width, height);
        ImgUtil.write(image, targetFile);
        return targetFile;
    }

    public static File generate(String content, QrConfig config, File targetFile) {
        BufferedImage image = QrCodeUtil.generate(content, config);
        ImgUtil.write(image, targetFile);
        return targetFile;
    }

    public static void generate(String content, int width, int height, String imageType, OutputStream out) {
        BufferedImage image = QrCodeUtil.generate(content, width, height);
        ImgUtil.write((Image)image, imageType, out);
    }

    public static void generate(String content, QrConfig config, String imageType, OutputStream out) {
        BufferedImage image = QrCodeUtil.generate(content, config);
        ImgUtil.write((Image)image, imageType, out);
    }

    public static BufferedImage generate(String content, int width, int height) {
        return QrCodeUtil.generate(content, QrConfig.of(width, height));
    }

    public static BufferedImage generate(String content, QrConfig config) {
        return new QrImage(content, ObjUtil.defaultIfNull(config, QrConfig::new));
    }

    public static BitMatrix encode(CharSequence content, QrConfig config) {
        return QrEncoder.of(config).encode(content);
    }

    public static String decode(InputStream qrCodeInputstream) {
        return QrCodeUtil.decode(ImgUtil.read(qrCodeInputstream));
    }

    public static String decode(File qrCodeFile) {
        return QrCodeUtil.decode(ImgUtil.read(qrCodeFile));
    }

    public static String decode(Image image) {
        return QrCodeUtil.decode(image, true, false);
    }

    public static String decode(Image image, boolean isTryHarder, boolean isPureBarcode) {
        return QrDecoder.of(isTryHarder, isPureBarcode).decode(image);
    }

    public static String decode(Image image, Map<DecodeHintType, Object> hints) {
        return QrDecoder.of(hints).decode(image);
    }

    public static BufferedImage toImage(BitMatrix matrix, int foreColor, Integer backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, null == backColor ? 2 : 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    image.setRGB(x, y, foreColor);
                    continue;
                }
                if (null == backColor) continue;
                image.setRGB(x, y, backColor);
            }
        }
        return image;
    }

    public static String generateAsSvg(String content, QrConfig qrConfig) {
        return QrCodeUtil.toSVG(QrCodeUtil.encode(content, qrConfig), qrConfig);
    }

    public static String toSVG(BitMatrix matrix, QrConfig config) {
        return new QrSVG(matrix, config).toString();
    }

    public static String generateAsAsciiArt(String content, QrConfig qrConfig) {
        return QrCodeUtil.toAsciiArt(QrCodeUtil.encode(content, qrConfig), qrConfig);
    }

    public static String toAsciiArt(BitMatrix bitMatrix, QrConfig qrConfig) {
        return new QrAsciiArt(bitMatrix, qrConfig).toString();
    }
}

