/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.util.function.Predicate;
import org.dromara.hutool.core.lang.mutable.Mutable;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONTokener;

public class JSONParser {
    private final JSONTokener tokener;

    public static JSONParser of(JSONTokener tokener) {
        return new JSONParser(tokener);
    }

    public JSONParser(JSONTokener tokener) {
        this.tokener = tokener;
    }

    public void parseTo(JSONObject jsonObject, Predicate<MutableEntry<String, Object>> predicate) {
        JSONTokener tokener = this.tokener;
        if (tokener.nextClean() != '{') {
            throw tokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block9: while (true) {
            char prev = tokener.getPrevious();
            char c = tokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw tokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
                case '[': 
                case '{': {
                    if (prev != '{') break;
                    throw tokener.syntaxError("A JSONObject can not directly nest another JSONObject or JSONArray.");
                }
            }
            tokener.back();
            String key = tokener.nextValue().toString();
            c = tokener.nextClean();
            if (c != ':') {
                throw tokener.syntaxError("Expected a ':' after a key");
            }
            jsonObject.set(key, tokener.nextValue(), predicate);
            switch (tokener.nextClean()) {
                case ',': 
                case ';': {
                    if (tokener.nextClean() == '}') {
                        return;
                    }
                    tokener.back();
                    continue block9;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw tokener.syntaxError("Expected a ',' or '}'");
    }

    public void parseTo(JSONArray jsonArray, Predicate<Mutable<Object>> predicate) {
        JSONTokener x = this.tokener;
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() != ']') {
            x.back();
            block4: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                    jsonArray.addRaw(null, predicate);
                } else {
                    x.back();
                    jsonArray.addRaw(x.nextValue(), predicate);
                }
                switch (x.nextClean()) {
                    case ',': {
                        if (x.nextClean() == ']') {
                            return;
                        }
                        x.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw x.syntaxError("Expected a ',' or ']'");
        }
    }
}

