/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting.toml;

import java.io.IOException;
import java.io.Writer;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.setting.SettingException;
import org.dromara.hutool.setting.toml.Toml;

public class TomlWriter {
    private final Writer writer;
    private final int indentSize;
    private final char indentCharacter;
    private final String lineSeparator;
    private final LinkedList<String> tablesNames = new LinkedList();
    private int lineBreaks = 0;
    private int indentationLevel = -1;

    public TomlWriter(Writer writer) {
        this(writer, 1, false, System.lineSeparator());
    }

    public TomlWriter(Writer writer, int indentSize, boolean indentWithSpaces) {
        this(writer, indentSize, indentWithSpaces, System.lineSeparator());
    }

    public TomlWriter(Writer writer, int indentSize, boolean indentWithSpaces, String lineSeparator) {
        this.writer = writer;
        this.indentSize = indentSize;
        this.indentCharacter = (char)(indentWithSpaces ? 32 : 9);
        this.lineSeparator = lineSeparator;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(Map<String, Object> data) throws IORuntimeException {
        this.writeTableContent(data);
    }

    private void writeTableName() throws IORuntimeException {
        Iterator it = this.tablesNames.iterator();
        while (it.hasNext()) {
            String namePart = (String)it.next();
            this.writeKey(namePart);
            if (!it.hasNext()) continue;
            this.write('.');
        }
    }

    private void writeTableContent(Map<String, Object> table) throws IORuntimeException {
        this.writeTableContent(table, true);
        this.writeTableContent(table, false);
    }

    private void writeTableContent(Map<String, Object> table, boolean simpleValues) throws IORuntimeException {
        for (Map.Entry<String, Object> entry : table.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                if (!c.isEmpty() && c.iterator().next() instanceof Map) {
                    if (simpleValues) continue;
                    this.tablesNames.addLast(name);
                    ++this.indentationLevel;
                    for (Object element : c) {
                        this.indent();
                        this.write("[[");
                        this.writeTableName();
                        this.write("]]\n");
                        Map map = (Map)element;
                        this.writeTableContent(map);
                    }
                    --this.indentationLevel;
                    this.tablesNames.removeLast();
                } else {
                    if (!simpleValues) continue;
                    this.indent();
                    this.writeKey(name);
                    this.write(" = ");
                    this.writeArray(c);
                }
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length > 0 && array[0] instanceof Map) {
                    if (simpleValues) continue;
                    this.tablesNames.addLast(name);
                    ++this.indentationLevel;
                    for (Object element : array) {
                        this.indent();
                        this.write("[[");
                        this.writeTableName();
                        this.write("]]\n");
                        Map map = (Map)element;
                        this.writeTableContent(map);
                    }
                    --this.indentationLevel;
                    this.tablesNames.removeLast();
                } else {
                    if (!simpleValues) continue;
                    this.indent();
                    this.writeKey(name);
                    this.write(" = ");
                    this.writeString(ArrayUtil.toString(array));
                }
            } else if (value instanceof Map) {
                if (simpleValues) continue;
                this.tablesNames.addLast(name);
                ++this.indentationLevel;
                this.indent();
                this.write('[');
                this.writeTableName();
                this.write(']');
                this.newLine();
                this.writeTableContent((Map)value);
                --this.indentationLevel;
                this.tablesNames.removeLast();
            } else {
                if (!simpleValues) continue;
                this.indent();
                this.writeKey(name);
                this.write(" = ");
                this.writeValue(value);
            }
            this.newLine();
        }
        this.newLine();
    }

    private void writeKey(String key) throws IORuntimeException {
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (TomlWriter.isValidCharOfKey(c)) continue;
            this.writeString(key);
            return;
        }
        this.write(key);
    }

    private static boolean isValidCharOfKey(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_';
    }

    private void writeString(String str) throws IORuntimeException {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            TomlWriter.addEscaped(c, sb);
        }
        sb.append('\"');
        this.write(sb.toString());
    }

    private void writeArray(Collection<?> c) throws IORuntimeException {
        this.write('[');
        for (Object element : c) {
            this.writeValue(element);
            this.write(", ");
        }
        this.write(']');
    }

    private void writeValue(Object value) throws IORuntimeException {
        if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof Number || value instanceof Boolean) {
            this.write(value.toString());
        } else if (value instanceof TemporalAccessor) {
            String formatted = Toml.DATE_FORMATTER.format((TemporalAccessor)value);
            if (formatted.endsWith("T")) {
                formatted = formatted.substring(0, formatted.length() - 1);
            }
            this.write(formatted);
        } else if (value instanceof Collection) {
            this.writeArray((Collection)value);
        } else if (ArrayUtil.isArray(value)) {
            this.write(ArrayUtil.toString(value));
        } else {
            if (value instanceof Map) {
                throw new IORuntimeException("Unexpected value " + value);
            }
            throw new SettingException("Unsupported value of type " + value.getClass().getCanonicalName());
        }
    }

    private void newLine() throws IORuntimeException {
        if (this.lineBreaks <= 1) {
            try {
                this.writer.write(this.lineSeparator);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            ++this.lineBreaks;
        }
    }

    private void write(char c) throws IORuntimeException {
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        this.lineBreaks = 0;
    }

    private void write(String str) throws IORuntimeException {
        try {
            this.writer.write(str);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        this.lineBreaks = 0;
    }

    private void indent() throws IORuntimeException {
        for (int i = 0; i < this.indentationLevel; ++i) {
            for (int j = 0; j < this.indentSize; ++j) {
                this.write(this.indentCharacter);
            }
        }
    }

    static void addEscaped(char c, StringBuilder sb) {
        switch (c) {
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\"': {
                sb.append("\\\"");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }
}

