/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing.clipboard;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.dromara.hutool.core.thread.ThreadUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.swing.clipboard.ClipboardListener;
import org.dromara.hutool.swing.clipboard.ClipboardUtil;

public class ClipboardMonitor
implements ClipboardOwner,
Runnable,
Closeable {
    public static final int DEFAULT_TRY_COUNT = 10;
    public static final long DEFAULT_DELAY = 100L;
    private final int tryCount;
    private final long delay;
    private final Clipboard clipboard;
    private final Set<ClipboardListener> listenerSet = new LinkedHashSet<ClipboardListener>();
    private boolean isRunning;

    public ClipboardMonitor() {
        this(10, 100L);
    }

    public ClipboardMonitor(int tryCount, long delay) {
        this(tryCount, delay, ClipboardUtil.getClipboard());
    }

    ClipboardMonitor(int tryCount, long delay, Clipboard clipboard) {
        this.tryCount = tryCount;
        this.delay = delay;
        this.clipboard = clipboard;
    }

    public ClipboardMonitor addListener(ClipboardListener listener) {
        this.listenerSet.add(listener);
        return this;
    }

    public ClipboardMonitor removeListener(ClipboardListener listener) {
        this.listenerSet.remove(listener);
        return this;
    }

    public ClipboardMonitor clearListener() {
        this.listenerSet.clear();
        return this;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        Transferable newContents;
        try {
            newContents = this.tryGetContent(clipboard);
        }
        catch (InterruptedException e) {
            return;
        }
        Transferable transferable = null;
        for (ClipboardListener listener : this.listenerSet) {
            try {
                transferable = listener.onChange(clipboard, ObjUtil.defaultIfNull(transferable, newContents));
            }
            catch (Throwable throwable) {}
        }
        if (this.isRunning) {
            clipboard.setContents(ObjUtil.defaultIfNull(transferable, ObjUtil.defaultIfNull(newContents, contents)), this);
        }
    }

    @Override
    public synchronized void run() {
        if (!this.isRunning) {
            Clipboard clipboard = this.clipboard;
            clipboard.setContents(clipboard.getContents(null), this);
            this.isRunning = true;
        }
    }

    public void listen(boolean sync) {
        this.run();
        if (sync) {
            ThreadUtil.sync(this);
        }
    }

    @Override
    public void close() {
        this.isRunning = false;
    }

    private Transferable tryGetContent(Clipboard clipboard) throws InterruptedException {
        Transferable newContents = null;
        for (int i = 0; i < this.tryCount; ++i) {
            if (this.delay > 0L && i > 0) {
                Thread.sleep(this.delay);
            }
            try {
                newContents = clipboard.getContents(null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (null == newContents) continue;
            return newContents;
        }
        return null;
    }
}

