/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing.img;

import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.builder.Builder;

public class RenderingHintsBuilder
implements Builder<RenderingHints> {
    private static final long serialVersionUID = 1L;
    private final Map<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>(10, 1.0f);

    public static RenderingHintsBuilder of() {
        return new RenderingHintsBuilder();
    }

    private RenderingHintsBuilder() {
    }

    public RenderingHintsBuilder setAntialiasing(Antialias antialias) {
        RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
        if (null == antialias) {
            this.hintsMap.remove(key);
        } else {
            this.hintsMap.put(key, antialias.getValue());
        }
        return this;
    }

    public RenderingHintsBuilder setTextAntialias(TextAntialias textAntialias) {
        RenderingHints.Key key = RenderingHints.KEY_TEXT_ANTIALIASING;
        if (null == textAntialias) {
            this.hintsMap.remove(key);
        } else {
            this.hintsMap.put(key, textAntialias.getValue());
        }
        return this;
    }

    public RenderingHintsBuilder setColorRendering(ColorRender colorRender) {
        RenderingHints.Key key = RenderingHints.KEY_COLOR_RENDERING;
        if (null == colorRender) {
            this.hintsMap.remove(key);
        } else {
            this.hintsMap.put(key, colorRender.getValue());
        }
        return this;
    }

    public RenderingHintsBuilder setDithering(Dither dither) {
        RenderingHints.Key key = RenderingHints.KEY_DITHERING;
        if (null == dither) {
            this.hintsMap.remove(key);
        } else {
            this.hintsMap.put(key, dither.getValue());
        }
        return this;
    }

    public RenderingHintsBuilder setFractionalMetrics(FractionalMetrics fractionalMetrics) {
        RenderingHints.Key key = RenderingHints.KEY_FRACTIONALMETRICS;
        if (null == fractionalMetrics) {
            this.hintsMap.remove(key);
        } else {
            this.hintsMap.put(key, fractionalMetrics.getValue());
        }
        return this;
    }

    public RenderingHintsBuilder setInterpolation(Interpolation interpolation) {
        RenderingHints.Key key = RenderingHints.KEY_INTERPOLATION;
        if (null == interpolation) {
            this.hintsMap.remove(key);
        } else {
            this.hintsMap.put(key, interpolation.getValue());
        }
        return this;
    }

    public RenderingHintsBuilder setAlphaInterpolation(AlphaInterpolation alphaInterpolation) {
        RenderingHints.Key key = RenderingHints.KEY_ALPHA_INTERPOLATION;
        if (null == alphaInterpolation) {
            this.hintsMap.remove(key);
        } else {
            this.hintsMap.put(key, alphaInterpolation.getValue());
        }
        return this;
    }

    public RenderingHintsBuilder setRendering(Render render) {
        RenderingHints.Key key = RenderingHints.KEY_RENDERING;
        if (null == render) {
            this.hintsMap.remove(key);
        } else {
            this.hintsMap.put(key, render.getValue());
        }
        return this;
    }

    public RenderingHintsBuilder setStrokeControl(StrokeControl strokeControl) {
        RenderingHints.Key key = RenderingHints.KEY_STROKE_CONTROL;
        if (null == strokeControl) {
            this.hintsMap.remove(key);
        } else {
            this.hintsMap.put(key, strokeControl.getValue());
        }
        return this;
    }

    public RenderingHintsBuilder setTextLCDContrast(Integer textLCDContrast) {
        RenderingHints.Key key = RenderingHints.KEY_TEXT_LCD_CONTRAST;
        if (null == textLCDContrast) {
            this.hintsMap.remove(key);
        } else {
            this.hintsMap.put(key, Assert.checkBetween((int)textLCDContrast, (int)100, (int)250));
        }
        return this;
    }

    public RenderingHints build() {
        return new RenderingHints(this.hintsMap);
    }

    public static enum StrokeControl {
        NORMALIZE(RenderingHints.VALUE_STROKE_NORMALIZE),
        PURE(RenderingHints.VALUE_STROKE_PURE),
        DEFAULT(RenderingHints.VALUE_STROKE_DEFAULT);

        private final Object value;

        private StrokeControl(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static enum AlphaInterpolation {
        SPEED(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED),
        QUALITY(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY),
        DEFAULT(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);

        private final Object value;

        private AlphaInterpolation(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static enum Interpolation {
        BICUBIC(RenderingHints.VALUE_INTERPOLATION_BICUBIC),
        BILINEAR(RenderingHints.VALUE_INTERPOLATION_BILINEAR),
        NEAREST_NEIGHBOR(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);

        private final Object value;

        private Interpolation(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static enum FractionalMetrics {
        SPEED(RenderingHints.VALUE_FRACTIONALMETRICS_ON),
        QUALITY(RenderingHints.VALUE_FRACTIONALMETRICS_OFF),
        DEFAULT(RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);

        private final Object value;

        private FractionalMetrics(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static enum Dither {
        ENABLE(RenderingHints.VALUE_DITHER_ENABLE),
        DISABLE(RenderingHints.VALUE_DITHER_DISABLE),
        DEFAULT(RenderingHints.VALUE_DITHER_DEFAULT);

        private final Object value;

        private Dither(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static enum Render {
        SPEED(RenderingHints.VALUE_RENDER_SPEED),
        QUALITY(RenderingHints.VALUE_RENDER_QUALITY),
        DEFAULT(RenderingHints.VALUE_RENDER_DEFAULT);

        private final Object value;

        private Render(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static enum ColorRender {
        SPEED(RenderingHints.VALUE_COLOR_RENDER_SPEED),
        QUALITY(RenderingHints.VALUE_COLOR_RENDER_QUALITY),
        DEFAULT(RenderingHints.VALUE_COLOR_RENDER_DEFAULT);

        private final Object value;

        private ColorRender(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static enum TextAntialias {
        ON(RenderingHints.VALUE_TEXT_ANTIALIAS_ON),
        OFF(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF),
        DEFAULT(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF),
        GASP(RenderingHints.VALUE_TEXT_ANTIALIAS_GASP),
        LCD_HRGB(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB),
        LCD_HBGR(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR),
        LCD_VRGB(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB),
        LCD_VBGR(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR);

        private final Object value;

        private TextAntialias(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static enum Antialias {
        ON(RenderingHints.VALUE_ANTIALIAS_ON),
        OFF(RenderingHints.VALUE_ANTIALIAS_OFF),
        DEFAULT(RenderingHints.VALUE_ANTIALIAS_OFF);

        private final Object value;

        private Antialias(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

