/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.comm.utils;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.Map;
import org.dromara.sms4j.comm.exception.SmsBlendException;

public class SmsHttpUtils {
    private SmsHttpUtils() {
    }

    public static SmsHttpUtils instance() {
        return SmsHttpHolder.INSTANCE;
    }

    public JSONObject postJson(String url, Map<String, String> headers, String body) {
        JSONObject jSONObject;
        block8: {
            HttpResponse response = ((HttpRequest)HttpRequest.post((String)url).addHeaders(headers)).body(body).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public JSONObject postJson(String url, Map<String, String> headers, Map<String, Object> body) {
        return this.postJson(url, headers, JSONUtil.toJsonStr(body));
    }

    public JSONObject postFrom(String url, Map<String, String> headers, Map<String, Object> body) {
        JSONObject jSONObject;
        block8: {
            HttpResponse response = ((HttpRequest)HttpRequest.post((String)url).addHeaders(headers)).form(body).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public JSONObject postBasicFrom(String url, Map<String, String> headers, String username, String password, Map<String, Object> body) {
        JSONObject jSONObject;
        block8: {
            HttpResponse response = ((HttpRequest)HttpRequest.post((String)url).addHeaders(headers)).basicAuth(username, password).form(body).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public JSONObject postUrl(String url, Map<String, String> headers, Map<String, Object> params) {
        JSONObject jSONObject;
        block8: {
            String urlWithParams = url + "?" + URLUtil.buildQuery(params, null);
            HttpResponse response = ((HttpRequest)HttpRequest.post((String)urlWithParams).addHeaders(headers)).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public JSONObject getBasic(String url, String username, String password) {
        JSONObject jSONObject;
        block8: {
            HttpResponse response = HttpRequest.get((String)url).basicAuth(username, password).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public JSONObject getUrl(String url) {
        JSONObject jSONObject;
        block8: {
            HttpResponse response = HttpRequest.get((String)url).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public void safeSleep(int retryInterval) {
        ThreadUtil.safeSleep((long)((long)retryInterval * 1000L));
    }

    private static class SmsHttpHolder {
        private static final SmsHttpUtils INSTANCE = new SmsHttpUtils();

        private SmsHttpHolder() {
        }
    }
}

