/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.aliyun.config;

import org.dromara.sms4j.aliyun.config.AlibabaConfig;
import org.dromara.sms4j.aliyun.service.AlibabaSmsImpl;
import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.provider.base.BaseProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlibabaFactory
implements BaseProviderFactory<AlibabaSmsImpl, AlibabaConfig> {
    private static final Logger log = LoggerFactory.getLogger(AlibabaFactory.class);
    private static AlibabaSmsImpl alibabaSms;
    private static final AlibabaFactory INSTANCE;

    private AlibabaFactory() {
    }

    public static AlibabaFactory instance() {
        return INSTANCE;
    }

    @Override
    public AlibabaSmsImpl createSms(AlibabaConfig alibabaConfig) {
        if (alibabaSms == null) {
            alibabaSms = this.createMultitonSms(alibabaConfig);
        }
        return alibabaSms;
    }

    @Override
    public AlibabaSmsImpl createMultitonSms(AlibabaConfig alibabaConfig) {
        return new AlibabaSmsImpl(alibabaConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
    }

    @Override
    public AlibabaSmsImpl refresh(AlibabaConfig alibabaConfig) {
        alibabaSms = new AlibabaSmsImpl(alibabaConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
        return alibabaSms;
    }

    @Override
    public AlibabaConfig getConfig() {
        return ConfigHolder.config;
    }

    @Override
    public void setConfig(AlibabaConfig config) {
        ConfigHolder.config = config;
    }

    static {
        INSTANCE = new AlibabaFactory();
    }

    private static final class ConfigHolder {
        private static AlibabaConfig config = AlibabaConfig.builder().build();

        private ConfigHolder() {
        }
    }
}

