/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.aliyun.service;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.dromara.sms4j.aliyun.config.AlibabaConfig;
import org.dromara.sms4j.aliyun.utils.AliyunUtils;
import org.dromara.sms4j.api.AbstractSmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlibabaSmsImpl
extends AbstractSmsBlend {
    private static final Logger log = LoggerFactory.getLogger(AlibabaSmsImpl.class);
    private final AlibabaConfig alibabaSmsConfig;

    public AlibabaSmsImpl(AlibabaConfig alibabaSmsConfig, Executor pool, DelayedTime delayedTime) {
        super(pool, delayedTime);
        this.alibabaSmsConfig = alibabaSmsConfig;
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.alibabaSmsConfig.getTemplateName(), message);
        return this.sendMessage(phone, this.alibabaSmsConfig.getTemplateId(), map);
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        String messageStr = JSONUtil.toJsonStr(messages);
        return this.getSmsResponse(phone, messageStr, templateId);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.alibabaSmsConfig.getTemplateName(), message);
        return this.massTexting(phones, this.alibabaSmsConfig.getTemplateId(), map);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        String messageStr = JSONUtil.toJsonStr(messages);
        return this.getSmsResponse(SmsUtil.arrayToString(phones), messageStr, templateId);
    }

    private SmsResponse getSmsResponse(String phone, String message, String templateId) {
        String paramStr;
        String requestUrl;
        AtomicReference reference = new AtomicReference();
        try {
            requestUrl = AliyunUtils.generateSendSmsRequestUrl(this.alibabaSmsConfig, message, phone, templateId);
            paramStr = AliyunUtils.generateParamBody(this.alibabaSmsConfig, phone, message, templateId);
        }
        catch (Exception e) {
            log.error("aliyun send message error", (Throwable)e);
            throw new SmsBlendException(e.getMessage());
        }
        log.debug("requestUrl {}", (Object)requestUrl);
        this.http.post(requestUrl).addHeader("Content-Type", (Object)"application/x-www-form-urlencoded").addBody(paramStr).onSuccess((data, req, res) -> reference.set(this.getResponse((JSONObject)res.get(JSONObject.class)))).onError((ex, req, res) -> reference.set(this.getResponse((JSONObject)res.get(JSONObject.class)))).execute();
        return (SmsResponse)reference.get();
    }

    private SmsResponse getResponse(JSONObject resJson) {
        SmsResponse smsResponse = new SmsResponse();
        if (resJson == null) {
            smsResponse.setErrorCode("500");
            smsResponse.setErrMessage("aliyun send sms response is null.check param");
            return smsResponse;
        }
        smsResponse.setCode(resJson.getStr((Object)"Code"));
        smsResponse.setMessage(resJson.getStr((Object)"Message"));
        if ("OK".equals(smsResponse.getCode())) {
            smsResponse.setBizId(resJson.getStr((Object)"BizId"));
            smsResponse.setSuccess(true);
        }
        return smsResponse;
    }
}

