/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.emay.service;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.dromara.sms4j.api.AbstractSmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtil;
import org.dromara.sms4j.emay.config.EmayConfig;
import org.dromara.sms4j.emay.util.EmayBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmaySmsImpl
extends AbstractSmsBlend {
    private static final Logger log = LoggerFactory.getLogger(EmaySmsImpl.class);
    private final EmayConfig config;

    public EmaySmsImpl(EmayConfig config, Executor pool, DelayedTime delayed) {
        super(pool, delayed);
        this.config = config;
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String message) {
        Map<String, Object> params;
        String url = this.config.getRequestUrl();
        try {
            params = EmayBuilder.buildRequestBody(this.config.getAppId(), this.config.getSecretKey(), phone, message);
        }
        catch (SmsBlendException e) {
            SmsResponse smsResponse = new SmsResponse();
            smsResponse.setErrMessage(e.getMessage());
            return smsResponse;
        }
        return this.getSendResponse(params, url);
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            list.add(entry.getValue());
        }
        return this.sendMessage(phone, EmayBuilder.listToString(list));
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String message) {
        if (phones.size() > 500) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e500");
        }
        return this.sendMessage(SmsUtil.listToString(phones), message);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (phones.size() > 500) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e500");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            list.add(entry.getValue());
        }
        return this.sendMessage(SmsUtil.listToString(phones), EmayBuilder.listToString(list));
    }

    private SmsResponse getSendResponse(Map<String, Object> body, String requestUrl) {
        AtomicReference smsResponse = new AtomicReference();
        this.http.post(requestUrl).addBody(body).onSuccess((data, req, res) -> smsResponse.set(EmaySmsImpl.getSmsResponse((JSONObject)res.get(JSONObject.class)))).onError((ex, req, res) -> smsResponse.set(EmaySmsImpl.getSmsResponse((JSONObject)res.get(JSONObject.class)))).execute();
        return (SmsResponse)smsResponse.get();
    }

    private static SmsResponse getSmsResponse(JSONObject execute) {
        SmsResponse smsResponse = new SmsResponse();
        if (execute == null) {
            smsResponse.setErrorCode("500");
            smsResponse.setErrMessage("emay send sms response is null.check param");
            return smsResponse;
        }
        String code = execute.getStr((Object)"code");
        if (SmsUtil.isEmpty((Object)code)) {
            smsResponse.setErrorCode("emay response code is null");
            smsResponse.setErrMessage("emay is error");
        } else {
            smsResponse.setCode(code);
            if ("success".equalsIgnoreCase(code)) {
                smsResponse.setSuccess(true);
                JSONArray data = execute.getJSONArray((Object)"data");
                JSONObject result = (JSONObject)data.get(0);
                String smsId = result.getStr((Object)"smsId");
                smsResponse.setBizId(smsId);
            }
            smsResponse.setData((Object)execute);
        }
        return smsResponse;
    }
}

