/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.jdcloud.config;

import com.jdcloud.sdk.auth.CredentialsProvider;
import com.jdcloud.sdk.auth.StaticCredentialsProvider;
import com.jdcloud.sdk.http.HttpRequestConfig;
import com.jdcloud.sdk.http.Protocol;
import com.jdcloud.sdk.service.sms.client.SmsClient;
import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.jdcloud.config.JdCloudConfig;
import org.dromara.sms4j.jdcloud.service.JdCloudSmsImpl;
import org.dromara.sms4j.provider.base.BaseProviderFactory;

public class JdCloudFactory
implements BaseProviderFactory<JdCloudSmsImpl, JdCloudConfig> {
    private static JdCloudSmsImpl jdCloudSms;
    private static final JdCloudFactory INSTANCE;

    private JdCloudFactory() {
    }

    public static JdCloudFactory instance() {
        return INSTANCE;
    }

    public SmsClient client(JdCloudConfig jdCloudConfig) {
        StaticCredentialsProvider credentialsProvider = new StaticCredentialsProvider(jdCloudConfig.getAccessKeyId(), jdCloudConfig.getAccessKeySecret());
        return SmsClient.builder().credentialsProvider((CredentialsProvider)credentialsProvider).httpRequestConfig(new HttpRequestConfig.Builder().protocol(Protocol.HTTP).build()).build();
    }

    @Override
    public JdCloudSmsImpl createSms(JdCloudConfig jdCloudConfig) {
        if (jdCloudSms == null) {
            jdCloudSms = this.createMultitonSms(jdCloudConfig);
        }
        return jdCloudSms;
    }

    @Override
    public JdCloudSmsImpl createMultitonSms(JdCloudConfig jdCloudConfig) {
        return new JdCloudSmsImpl(this.client(jdCloudConfig), jdCloudConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
    }

    @Override
    public JdCloudSmsImpl refresh(JdCloudConfig jdCloudConfig) {
        jdCloudSms = new JdCloudSmsImpl(this.client(jdCloudConfig), jdCloudConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
        return jdCloudSms;
    }

    @Override
    public JdCloudConfig getConfig() {
        return ConfigHolder.config;
    }

    @Override
    public void setConfig(JdCloudConfig config) {
        ConfigHolder.config = config;
    }

    static {
        INSTANCE = new JdCloudFactory();
    }

    private static final class ConfigHolder {
        private static JdCloudConfig config = JdCloudConfig.builder().build();

        private ConfigHolder() {
        }
    }
}

