/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.tencent.service;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.jdcloud.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.AbstractSmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtil;
import org.dromara.sms4j.tencent.config.TencentConfig;
import org.dromara.sms4j.tencent.utils.TencentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentSmsImpl
extends AbstractSmsBlend {
    private static final Logger log = LoggerFactory.getLogger(TencentSmsImpl.class);
    private final TencentConfig tencentSmsConfig;

    public TencentSmsImpl(TencentConfig tencentSmsConfig, Executor pool, DelayedTime delayed) {
        super(pool, delayed);
        this.tencentSmsConfig = tencentSmsConfig;
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String message) {
        String[] split = message.split("&");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < split.length; ++i) {
            map.put(String.valueOf(i), split[i]);
        }
        return this.sendMessage(phone, this.tencentSmsConfig.getTemplateId(), map);
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            list.add(entry.getValue());
        }
        String[] s = new String[list.size()];
        return this.getSmsResponse(new String[]{"+86" + phone}, list.toArray(s), templateId);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String message) {
        String[] split = message.split("&");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < split.length; ++i) {
            map.put(String.valueOf(i), split[i]);
        }
        return this.massTexting(phones, this.tencentSmsConfig.getTemplateId(), map);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            list.add(entry.getValue());
        }
        String[] s = new String[list.size()];
        return this.getSmsResponse(SmsUtil.listToArray(phones), list.toArray(s), templateId);
    }

    private SmsResponse getSmsResponse(String[] phones, String[] messages, String templateId) {
        String signature;
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        try {
            signature = TencentUtils.generateSignature(this.tencentSmsConfig, templateId, messages, phones, timestamp);
        }
        catch (Exception e) {
            log.error("tencent send message error", (Throwable)e);
            throw new SmsBlendException(e.getMessage());
        }
        Map<String, Object> headsMap = TencentUtils.generateHeadsMap(signature, timestamp, this.tencentSmsConfig.getAction(), this.tencentSmsConfig.getVersion(), this.tencentSmsConfig.getTerritory(), this.tencentSmsConfig.getRequestUrl());
        Map<String, Object> requestBody = TencentUtils.generateRequestBody(phones, this.tencentSmsConfig.getSdkAppId(), this.tencentSmsConfig.getSignature(), templateId, messages);
        SmsResponse smsResponse = new SmsResponse();
        String url = "https://" + this.tencentSmsConfig.getRequestUrl();
        this.http.post(url).addHeader(headsMap).addBody(requestBody).onSuccess((data, req, res) -> {
            JSONObject jsonBody = (JSONObject)res.get(JSONObject.class);
            JSONObject response = jsonBody.getJSONObject((Object)"Response");
            String error = response.getStr((Object)"Error");
            if (StringUtils.isNotBlank((CharSequence)error)) {
                smsResponse.setErrorCode("500");
                smsResponse.setErrMessage(error);
            } else {
                JSONArray sendStatusSet = response.getJSONArray((Object)"SendStatusSet");
                smsResponse.setBizId(sendStatusSet.getJSONObject((Object)0).getStr((Object)"SerialNo"));
                smsResponse.setMessage(sendStatusSet.getJSONObject((Object)0).getStr((Object)"Message"));
                smsResponse.setCode(sendStatusSet.getJSONObject((Object)0).getStr((Object)"Code"));
                smsResponse.setSuccess(true);
            }
        }).onError((ex, req, res) -> {
            JSONObject jsonBody = (JSONObject)res.get(JSONObject.class);
            if (jsonBody == null) {
                smsResponse.setErrorCode("500");
                smsResponse.setErrMessage("tencent send sms response is null.check param");
            } else {
                JSONObject response = jsonBody.getJSONObject((Object)"Response");
                JSONArray sendStatusSet = response.getJSONArray((Object)"SendStatusSet");
                smsResponse.setErrMessage(sendStatusSet.getJSONObject((Object)0).getStr((Object)"Message"));
                smsResponse.setErrorCode(sendStatusSet.getJSONObject((Object)0).getStr((Object)"Code"));
            }
        }).execute();
        return smsResponse;
    }
}

