/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.yunpian.service;

import cn.hutool.json.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.dromara.sms4j.api.AbstractSmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtil;
import org.dromara.sms4j.yunpian.config.YunpianConfig;

public class YunPianSmsImpl
extends AbstractSmsBlend {
    private final YunpianConfig config;

    public YunPianSmsImpl(YunpianConfig config, Executor pool, DelayedTime delayed) {
        super(pool, delayed);
        this.config = config;
    }

    private static SmsResponse getSmsResponse(JSONObject execute) {
        SmsResponse smsResponse = new SmsResponse();
        if (execute == null) {
            smsResponse.setErrorCode("500");
            smsResponse.setErrMessage("yunpian send sms response is null.check param");
            return smsResponse;
        }
        smsResponse.setCode(execute.getStr((Object)"code"));
        smsResponse.setMessage(execute.getStr((Object)"msg"));
        smsResponse.setBizId(execute.getStr((Object)"sid"));
        smsResponse.setSuccess(execute.getInt((Object)"code") == 0);
        if (!smsResponse.isSuccess()) {
            smsResponse.setErrMessage(execute.getStr((Object)"msg"));
        }
        smsResponse.setData((Object)execute);
        return smsResponse;
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String message) {
        Map<String, String> body = this.setBody(phone, message, null, this.config.getTemplateId());
        return this.getSendResponse(body);
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        Map<String, String> body = this.setBody(phone, "", messages, templateId);
        return this.getSendResponse(body);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String message) {
        if (phones.size() > 1000) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e1000");
        }
        return this.sendMessage(SmsUtil.listToString(phones), message);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (phones.size() > 1000) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e1000");
        }
        return this.sendMessage(SmsUtil.listToString(phones), templateId, messages);
    }

    private String formattingMap(Map<String, String> messages) {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            str.append("#");
            str.append(entry.getKey());
            str.append("#=");
            str.append(entry.getValue());
            str.append("&");
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    private Map<String, String> setBody(String phone, String mes, LinkedHashMap<String, String> messages, String tplId) {
        LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
        if (mes.isEmpty()) {
            message = messages;
        } else {
            message.put(this.config.getTemplateName(), mes);
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("apikey", this.config.getAccessKeyId());
        body.put("mobile", phone);
        body.put("tpl_id", tplId);
        body.put("tpl_value", this.formattingMap(message));
        if (this.config.getCallbackUrl() != null && !this.config.getCallbackUrl().isEmpty()) {
            body.put("callback_url", this.config.getCallbackUrl());
        }
        return body;
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json;charset=utf-8");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return headers;
    }

    private SmsResponse getSendResponse(Map<String, String> body) {
        Map<String, String> headers = this.getHeaders();
        AtomicReference smsResponse = new AtomicReference();
        this.http.post("https://sms.yunpian.com/v2/sms/tpl_single_send.json").addHeader(headers).addBody(body).onSuccess((data, req, res) -> smsResponse.set(YunPianSmsImpl.getSmsResponse((JSONObject)res.get(JSONObject.class)))).onError((ex, req, res) -> smsResponse.set(YunPianSmsImpl.getSmsResponse((JSONObject)res.get(JSONObject.class)))).execute();
        return (SmsResponse)smsResponse.get();
    }
}

