/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.jg.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.jg.config.JgConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JgUtils {
    private static final Logger log = LoggerFactory.getLogger(JgUtils.class);

    public static String buildUrl(String baseUrl, String action, String msgId) {
        if ("valid".equals(action)) {
            JgUtils.check(msgId);
            return baseUrl + "codes/" + msgId + "/" + action;
        }
        return baseUrl + action;
    }

    public static Map<String, String> buildHeaders(String accessKeyId, String accessKeySecret) {
        JgUtils.check(accessKeyId);
        JgUtils.check(accessKeySecret);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(3);
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json; charset=utf-8");
        headers.put("Authorization", "Basic " + Base64.encode((CharSequence)(accessKeyId + ":" + accessKeySecret), (Charset)StandardCharsets.UTF_8));
        return headers;
    }

    public static Map<String, Object> buildBody(String phone, LinkedHashMap<String, String> messages, String templateId, JgConfig config, String code) {
        JgUtils.checkAction(config.getAction());
        switch (config.getAction()) {
            case "codes": {
                return JgUtils.buildBody(phone, config.getSignId(), templateId);
            }
            case "voice_codes": {
                return JgUtils.buildBody(phone, code, config.getVoice(), config.getTtl());
            }
            case "valid": {
                return JgUtils.buildBody(code);
            }
            case "messages/batch": {
                return JgUtils.buildBody(phone, config.getSignId(), templateId, config.getTag(), messages);
            }
        }
        return JgUtils.buildBody(phone, config.getSignId(), templateId, messages);
    }

    public static String buildJsonKey(String action) {
        JgUtils.checkAction(action);
        switch (action) {
            case "valid": {
                return "is_valid";
            }
            case "messages/batch": {
                return "success_count";
            }
        }
        return "msg_id";
    }

    private static Map<String, Object> buildBody(String phone, String signId, String templateId) {
        JgUtils.checkSingle(phone);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
        map.put("mobile", phone);
        JgUtils.check(templateId);
        map.put("temp_id", templateId);
        if (SmsUtils.isNotEmpty((Object)signId)) {
            map.put("sign_id", signId);
        }
        return map;
    }

    private static Map<String, Object> buildBody(String phone, String code, String voice, Integer ttl) {
        JgUtils.checkSingle(phone);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(1);
        map.put("mobile", phone);
        if (SmsUtils.isNotEmpty((Object)code)) {
            map.put("code", code);
        }
        if (SmsUtils.isNotEmpty((Object)voice)) {
            JgUtils.checkVoice(voice);
            map.put("voice_lang", voice);
        }
        if (ttl == null || ttl <= 0) {
            map.put("ttl", 60);
        } else {
            map.put("ttl", ttl);
        }
        return map;
    }

    private static Map<String, Object> buildBody(String code) {
        JgUtils.check(code);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(1);
        map.put("code", code);
        return map;
    }

    private static Map<String, Object> buildBody(String phone, String signId, String templateId, LinkedHashMap<String, String> messages) {
        JgUtils.checkSingle(phone);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(1);
        map.put("mobile", phone);
        if (SmsUtils.isNotEmpty((Object)signId)) {
            map.put("sign_id", signId);
        }
        JgUtils.check(templateId);
        map.put("temp_id", templateId);
        JgUtils.checkMessages(messages);
        map.put("temp_para", messages);
        return map;
    }

    private static Map<String, Object> buildBody(String phone, String signId, String templateId, String tag, LinkedHashMap<String, String> messages) {
        Set<String> phones = JgUtils.build(phone);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(1);
        if (SmsUtils.isNotEmpty((Object)signId)) {
            map.put("sign_id", signId);
        }
        if (SmsUtils.isNotEmpty((Object)tag)) {
            map.put("tag", tag);
        }
        if (SmsUtils.isEmpty((Object)templateId)) {
            log.error("templateId is required");
            throw new SmsBlendException("templateId is required");
        }
        map.put("temp_id", templateId);
        if (SmsUtils.isEmpty(messages)) {
            log.error("temp_para is required");
            throw new SmsBlendException("temp_para is required");
        }
        ArrayList recipients = new ArrayList(phones.size());
        phones.forEach(mobile -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(1);
            params.put("mobile", StrUtil.addPrefixIfNot((CharSequence)mobile, (CharSequence)"+86"));
            params.put("temp_para", messages);
            recipients.add(params);
        });
        map.put("recipients", recipients);
        return map;
    }

    private static Set<String> build(String phone) {
        JgUtils.check(phone);
        return Arrays.stream(phone.split(",")).filter(SmsUtils::isNotEmpty).map(String::trim).collect(Collectors.toSet());
    }

    private static void checkSingle(String phone) {
        Set<String> phones = JgUtils.build(phone);
        if (phones.size() > 1) {
            log.error("Only a single mobile number is supported");
            throw new SmsBlendException("Only a single mobile number is supported");
        }
    }

    private static void checkMessages(LinkedHashMap<String, String> messages) {
        if (SmsUtils.isEmpty(messages)) {
            log.error("temp_para is required");
            throw new SmsBlendException("temp_para is required");
        }
    }

    private static void checkVoice(String voice) {
        if (!StrUtil.equalsAny((CharSequence)voice, (CharSequence[])new CharSequence[]{"0", "1", "2"})) {
            log.error("voice_lang is error, the value of an is only [1,2,3]");
            throw new SmsBlendException("voice_lang is error, the value of an is only [1,2,3]");
        }
    }

    private static void checkAction(String action) {
        if (SmsUtils.isEmpty((Object)action) || !StrUtil.equalsAny((CharSequence)action, (CharSequence[])new CharSequence[]{"codes", "voice_codes", "valid", "messages", "messages/batch"})) {
            log.error("Unknown action method");
            throw new SmsBlendException("Unknown action method");
        }
    }

    private static void check(String str) {
        if (SmsUtils.isEmpty((Object)str)) {
            String error = str + " is required";
            log.error(error);
            throw new SmsBlendException(error);
        }
    }
}

