/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.starter.aop;

import java.util.Objects;
import org.dromara.sms4j.api.smsProxy.RestrictedProcess;
import org.dromara.sms4j.api.universal.RedisUtil;
import org.dromara.sms4j.comm.config.SmsConfig;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtil;
import org.dromara.sms4j.starter.utils.SpringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedProcessImpl
extends RestrictedProcess {
    private static final Logger log = LoggerFactory.getLogger(RestrictedProcessImpl.class);
    private static final Long minTimer = 60000L;
    private static final Long accTimer = 86400000L;
    private static final String REDIS_KEY = "sms:restricted:";

    /*
     * Enabled aggressive block sorting
     */
    public SmsBlendException process(SmsConfig config, String args) throws Exception {
        RedisUtil redis = SpringUtil.getBean(RedisUtil.class);
        if (Objects.isNull(redis)) {
            throw new SmsBlendException("The redis tool could not be found");
        }
        Integer accountMax = config.getAccountMax();
        Integer minuteMax = config.getMinuteMax();
        if (SmsUtil.isNotEmpty((Object)accountMax)) {
            Integer i = (Integer)redis.getByKey(REDIS_KEY + args + "max");
            if (SmsUtil.isEmpty((Object)i)) {
                redis.setOrTime(REDIS_KEY + args + "max", (Object)1, Long.valueOf(accTimer / 1000L));
            } else {
                if (i > accountMax) {
                    log.info("The phone:" + args + ",number of short messages reached the maximum today");
                    return new SmsBlendException("The phone:" + args + ",number of short messages reached the maximum today");
                }
                redis.setOrTime(REDIS_KEY + args + "max", (Object)(i + 1), Long.valueOf(accTimer / 1000L));
            }
        }
        if (!SmsUtil.isNotEmpty((Object)minuteMax)) return null;
        Integer o = (Integer)redis.getByKey(REDIS_KEY + args);
        if (!SmsUtil.isNotEmpty((Object)o)) {
            redis.setOrTime(REDIS_KEY + args, (Object)1, Long.valueOf(minTimer / 1000L));
            return null;
        }
        if (o < minuteMax) {
            redis.setOrTime(REDIS_KEY + args, (Object)(o + 1), Long.valueOf(minTimer / 1000L));
            return null;
        }
        log.info("The phone:" + args + ",number of short messages reached the maximum today");
        return new SmsBlendException("The phone:", args + " Text messages are sent too often\uff01");
    }
}

