/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.plugin.modes.sb.config;

import java.util.Objects;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.config.WarmFlow;
import org.dromara.warm.flow.core.invoker.FrameInvoker;
import org.dromara.warm.flow.core.orm.dao.FlowDefinitionDao;
import org.dromara.warm.flow.core.orm.dao.FlowFormDao;
import org.dromara.warm.flow.core.orm.dao.FlowHisTaskDao;
import org.dromara.warm.flow.core.orm.dao.FlowInstanceDao;
import org.dromara.warm.flow.core.orm.dao.FlowNodeDao;
import org.dromara.warm.flow.core.orm.dao.FlowSkipDao;
import org.dromara.warm.flow.core.orm.dao.FlowTaskDao;
import org.dromara.warm.flow.core.orm.dao.FlowUserDao;
import org.dromara.warm.flow.core.service.ChartService;
import org.dromara.warm.flow.core.service.DefService;
import org.dromara.warm.flow.core.service.FormService;
import org.dromara.warm.flow.core.service.HisTaskService;
import org.dromara.warm.flow.core.service.InsService;
import org.dromara.warm.flow.core.service.NodeService;
import org.dromara.warm.flow.core.service.SkipService;
import org.dromara.warm.flow.core.service.TaskService;
import org.dromara.warm.flow.core.service.UserService;
import org.dromara.warm.flow.core.service.impl.ChartServiceImpl;
import org.dromara.warm.flow.core.service.impl.DefServiceImpl;
import org.dromara.warm.flow.core.service.impl.FormServiceImpl;
import org.dromara.warm.flow.core.service.impl.HisTaskServiceImpl;
import org.dromara.warm.flow.core.service.impl.InsServiceImpl;
import org.dromara.warm.flow.core.service.impl.NodeServiceImpl;
import org.dromara.warm.flow.core.service.impl.SkipServiceImpl;
import org.dromara.warm.flow.core.service.impl.TaskServiceImpl;
import org.dromara.warm.flow.core.service.impl.UserServiceImpl;
import org.dromara.warm.flow.core.strategy.ExpressionStrategy;
import org.dromara.warm.flow.core.utils.ExpressionUtil;
import org.dromara.warm.flow.orm.dao.FlowDefinitionDaoImpl;
import org.dromara.warm.flow.orm.dao.FlowFormDaoImpl;
import org.dromara.warm.flow.orm.dao.FlowHisTaskDaoImpl;
import org.dromara.warm.flow.orm.dao.FlowInstanceDaoImpl;
import org.dromara.warm.flow.orm.dao.FlowNodeDaoImpl;
import org.dromara.warm.flow.orm.dao.FlowSkipDaoImpl;
import org.dromara.warm.flow.orm.dao.FlowTaskDaoImpl;
import org.dromara.warm.flow.orm.dao.FlowUserDaoImpl;
import org.dromara.warm.flow.orm.entity.FlowDefinition;
import org.dromara.warm.flow.orm.entity.FlowForm;
import org.dromara.warm.flow.orm.entity.FlowHisTask;
import org.dromara.warm.flow.orm.entity.FlowInstance;
import org.dromara.warm.flow.orm.entity.FlowNode;
import org.dromara.warm.flow.orm.entity.FlowSkip;
import org.dromara.warm.flow.orm.entity.FlowTask;
import org.dromara.warm.flow.orm.entity.FlowUser;
import org.dromara.warm.plugin.modes.sb.config.WarmFlowProperties;
import org.dromara.warm.plugin.modes.sb.expression.ConditionStrategyDefault;
import org.dromara.warm.plugin.modes.sb.expression.ConditionStrategySpel;
import org.dromara.warm.plugin.modes.sb.expression.ListenerStrategySpel;
import org.dromara.warm.plugin.modes.sb.expression.VariableStrategySpel;
import org.dromara.warm.plugin.modes.sb.helper.SpelHelper;
import org.dromara.warm.plugin.modes.sb.utils.SpringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Import(value={SpringUtil.class, SpelHelper.class})
@ConditionalOnProperty(value={"warm-flow.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={WarmFlowProperties.class})
public class BeanConfig {
    private static final Logger log = LoggerFactory.getLogger(BeanConfig.class);

    @Bean
    public FlowDefinitionDao definitionDao() {
        return new FlowDefinitionDaoImpl();
    }

    @Bean
    public DefService definitionService(FlowDefinitionDao definitionDao) {
        return new DefServiceImpl().setDao(definitionDao);
    }

    @Bean
    public ChartService chartService() {
        return new ChartServiceImpl();
    }

    @Bean
    public FlowNodeDao nodeDao() {
        return new FlowNodeDaoImpl();
    }

    @Bean
    public NodeService nodeService(FlowNodeDao nodeDao) {
        return new NodeServiceImpl().setDao(nodeDao);
    }

    @Bean
    public FlowSkipDao skipDao() {
        return new FlowSkipDaoImpl();
    }

    @Bean
    public SkipService skipService(FlowSkipDao skipDao) {
        return new SkipServiceImpl().setDao(skipDao);
    }

    @Bean
    public FlowInstanceDao instanceDao() {
        return new FlowInstanceDaoImpl();
    }

    @Bean
    public InsService instanceService(FlowInstanceDao instanceDao) {
        return new InsServiceImpl().setDao(instanceDao);
    }

    @Bean
    public FlowTaskDao taskDao() {
        return new FlowTaskDaoImpl();
    }

    @Bean
    public TaskService taskService(FlowTaskDao taskDao) {
        return new TaskServiceImpl().setDao(taskDao);
    }

    @Bean
    public FlowHisTaskDao hisTaskDao() {
        return new FlowHisTaskDaoImpl();
    }

    @Bean
    public HisTaskService hisTaskService(FlowHisTaskDao hisTaskDao) {
        return new HisTaskServiceImpl().setDao(hisTaskDao);
    }

    @Bean
    public FlowUserDao flowUserDao() {
        return new FlowUserDaoImpl();
    }

    @Bean
    public UserService flowUserService(FlowUserDao userDao) {
        return new UserServiceImpl().setDao(userDao);
    }

    @Bean
    public FlowFormDao formDao() {
        return new FlowFormDaoImpl();
    }

    @Bean
    public FormService flowFormService(FlowFormDao formDao) {
        return new FormServiceImpl().setDao(formDao);
    }

    @Bean
    public WarmFlow initFlow() {
        this.setNewEntity();
        FrameInvoker.setCfgFunction(key -> Objects.requireNonNull(SpringUtil.getBean(Environment.class)).getProperty(key));
        FrameInvoker.setBeanFunction(SpringUtil::getBean);
        WarmFlowProperties warmFlow = SpringUtil.getBean(WarmFlowProperties.class);
        warmFlow.init();
        FlowEngine.setFlowConfig((WarmFlow)warmFlow);
        this.setExpression();
        this.after(warmFlow);
        log.info("\u3010warm-flow\u3011\uff0c\u52a0\u8f7d\u5b8c\u6210");
        return warmFlow;
    }

    private void setExpression() {
        ExpressionUtil.setExpression((ExpressionStrategy)new ConditionStrategyDefault());
        ExpressionUtil.setExpression((ExpressionStrategy)new ConditionStrategySpel());
        ExpressionUtil.setExpression((ExpressionStrategy)new ListenerStrategySpel());
        ExpressionUtil.setExpression((ExpressionStrategy)new VariableStrategySpel());
    }

    public void setNewEntity() {
        FlowEngine.setNewDef(FlowDefinition::new);
        FlowEngine.setNewIns(FlowInstance::new);
        FlowEngine.setNewHisTask(FlowHisTask::new);
        FlowEngine.setNewNode(FlowNode::new);
        FlowEngine.setNewSkip(FlowSkip::new);
        FlowEngine.setNewTask(FlowTask::new);
        FlowEngine.setNewUser(FlowUser::new);
        FlowEngine.setNewForm(FlowForm::new);
    }

    public void after(WarmFlow flowConfig) {
    }
}

