/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.drlx.expr;

import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.BooleanLiteralExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.BinaryExprMetaModel;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.printer.Printable;
import org.drools.javaparser.utils.Utils;

public final class HalfBinaryExpr
extends Expression {
    private Expression right;
    private Operator operator;

    public HalfBinaryExpr() {
        this(null, new BooleanLiteralExpr(), Operator.EQUALS);
    }

    @AllFieldsConstructor
    public HalfBinaryExpr(Expression right, Operator operator) {
        this(null, right, operator);
    }

    public HalfBinaryExpr(TokenRange tokenRange, Expression right, Operator operator) {
        super(tokenRange);
        this.setRight(right);
        this.setOperator(operator);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.getRuleVisitor().visit(this, arg);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getRight() {
        return this.right;
    }

    public HalfBinaryExpr setOperator(Operator operator) {
        Utils.assertNotNull(operator);
        if (operator == this.operator) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.OPERATOR, this.operator, operator);
        this.operator = operator;
        return this;
    }

    public HalfBinaryExpr setRight(Expression right) {
        Utils.assertNotNull(right);
        if (right == this.right) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.RIGHT, this.right, right);
        if (this.right != null) {
            this.right.setParentNode(null);
        }
        this.right = right;
        this.setAsParentNodeOf(right);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public HalfBinaryExpr clone() {
        return (HalfBinaryExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public BinaryExprMetaModel getMetaModel() {
        return JavaParserMetaModel.binaryExprMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.right) {
            this.setRight((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    public static enum Operator implements Printable
    {
        EQUALS("=="),
        NOT_EQUALS("!="),
        LESS("<"),
        GREATER(">"),
        LESS_EQUALS("<="),
        GREATER_EQUALS(">=");

        private final String codeRepresentation;

        private Operator(String codeRepresentation) {
            this.codeRepresentation = codeRepresentation;
        }

        @Override
        public String asString() {
            return this.codeRepresentation;
        }
    }
}

