/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.type;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.expr.AnnotationExpr;
import org.drools.javaparser.ast.nodeTypes.NodeWithAnnotations;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.type.ReferenceType;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.NonEmptyProperty;
import org.drools.javaparser.metamodel.UnionTypeMetaModel;
import org.drools.javaparser.resolution.types.ResolvedUnionType;
import org.drools.javaparser.utils.Utils;

public final class UnionType
extends Type
implements NodeWithAnnotations<UnionType> {
    @NonEmptyProperty
    private NodeList<ReferenceType> elements;

    public UnionType() {
        this((TokenRange)null, new NodeList<ReferenceType>());
    }

    public UnionType(TokenRange tokenRange, NodeList<ReferenceType> elements) {
        super(tokenRange);
        this.setElements(elements);
        this.customInitialization();
    }

    @AllFieldsConstructor
    public UnionType(NodeList<ReferenceType> elements) {
        this((TokenRange)null, elements);
    }

    public NodeList<ReferenceType> getElements() {
        return this.elements;
    }

    public UnionType setElements(NodeList<ReferenceType> elements) {
        Utils.assertNotNull(elements);
        if (elements == this.elements) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ELEMENTS, this.elements, elements);
        if (this.elements != null) {
            this.elements.setParentNode(null);
        }
        this.elements = elements;
        this.setAsParentNodeOf(elements);
        return this;
    }

    @Override
    public UnionType setAnnotations(NodeList<AnnotationExpr> annotations) {
        return (UnionType)super.setAnnotations(annotations);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i) != node) continue;
            this.elements.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public String asString() {
        return this.elements.stream().map(Type::asString).collect(Collectors.joining("|"));
    }

    @Override
    public UnionType clone() {
        return (UnionType)this.accept(new CloneVisitor(), null);
    }

    @Override
    public UnionTypeMetaModel getMetaModel() {
        return JavaParserMetaModel.unionTypeMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i) != node) continue;
            this.elements.set(i, (ReferenceType)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isUnionType() {
        return true;
    }

    @Override
    public UnionType asUnionType() {
        return this;
    }

    @Override
    public void ifUnionType(Consumer<UnionType> action) {
        action.accept(this);
    }

    @Override
    public ResolvedUnionType resolve() {
        return this.getSymbolResolver().toResolvedType(this, ResolvedUnionType.class);
    }

    @Override
    public Optional<UnionType> toUnionType() {
        return Optional.of(this);
    }
}

