/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.ancompiler.AbstractCompilerHandler;
import org.drools.ancompiler.CanInlineInANC;
import org.drools.ancompiler.ListUtils;
import org.drools.core.common.NetworkNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.util.StringUtils;

public class InlineFieldReferenceInitHandler {
    private static final String METHOD_NAME = "initConstraintsResults";
    private static final String statementCall = "         {   initNodeN();\n}";
    private final List<NetworkNode> nodes;
    private List<FieldDeclaration> additionalFields;
    private final Map<Integer, CompilationUnit> partitionedNodeInitialisationClasses = new HashMap<Integer, CompilationUnit>();

    public InlineFieldReferenceInitHandler(List<NetworkNode> nodes, List<FieldDeclaration> additionalFields) {
        this.nodes = nodes;
        this.additionalFields = additionalFields;
    }

    public Collection<CompilationUnit> getPartitionedNodeInitialisationClasses() {
        return this.partitionedNodeInitialisationClasses.values();
    }

    public void emitCode(StringBuilder builder) {
        ArrayList<MethodDeclaration> allMethods = new ArrayList<MethodDeclaration>();
        MethodDeclaration methodDeclaration = new MethodDeclaration(NodeList.nodeList((Node[])new Modifier[]{Modifier.publicModifier()}), (Type)new VoidType(), METHOD_NAME);
        allMethods.add(methodDeclaration);
        BlockStmt setNetworkNodeReference = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new RuntimeException("No block statement"));
        List<List<NetworkNode>> partitionedNodes = ListUtils.partition(this.nodes, 20);
        for (int i = 0; i < partitionedNodes.size(); ++i) {
            List<NetworkNode> nodesInPartition = partitionedNodes.get(i);
            MethodDeclaration m = this.generateInitMethodForPartition(i, nodesInPartition, setNetworkNodeReference);
            allMethods.add(m);
        }
        for (MethodDeclaration md : allMethods) {
            builder.append(md.toString());
            builder.append("\n");
        }
    }

    private MethodDeclaration generateInitMethodForPartition(int partitionIndex, List<NetworkNode> nodeInPartition, BlockStmt setNetworkNodeReferenceBody) {
        String initWithIndex = "initNode" + partitionIndex;
        CompilationUnit initialisationCompilationUnit = new CompilationUnit();
        initialisationCompilationUnit.setPackageDeclaration("org.drools.ancompiler");
        initialisationCompilationUnit.addClass(StringUtils.ucFirst((String)initWithIndex));
        this.partitionedNodeInitialisationClasses.put(partitionIndex, initialisationCompilationUnit);
        BlockStmt setFieldStatementCall = StaticJavaParser.parseBlock((String)statementCall);
        setFieldStatementCall.findAll(MethodCallExpr.class, mc -> mc.getNameAsString().equals("initNodeN")).forEach(n -> n.setName(new SimpleName(initWithIndex)));
        setFieldStatementCall.getStatements().forEach(arg_0 -> ((BlockStmt)setNetworkNodeReferenceBody).addStatement(arg_0));
        MethodDeclaration initMethodWithIndex = new MethodDeclaration(NodeList.nodeList((Node[])new Modifier[]{Modifier.publicModifier()}), (Type)new VoidType(), initWithIndex);
        BlockStmt initBlockPerPartition = (BlockStmt)initMethodWithIndex.getBody().orElseThrow(() -> new RuntimeException("No"));
        this.generateInitBody(initBlockPerPartition, nodeInPartition, partitionIndex);
        return initMethodWithIndex;
    }

    private void generateInitBody(BlockStmt initBodyPerPartition, List<NetworkNode> subNodes, int partitionIndex) {
        CompilationUnit partitionedCompilationUnit = this.partitionedNodeInitialisationClasses.get(partitionIndex);
        PackageDeclaration partitionedClassPackage = (PackageDeclaration)partitionedCompilationUnit.getChildNodes().get(0);
        ClassOrInterfaceDeclaration partitionedClass = (ClassOrInterfaceDeclaration)partitionedCompilationUnit.getChildNodes().get(1);
        for (NetworkNode n : subNodes) {
            ClassOrInterfaceType initMethodReturnType;
            String variableName;
            if (!(n instanceof CanInlineInANC)) continue;
            if (n instanceof AlphaNode) {
                variableName = AbstractCompilerHandler.getVariableName((AlphaNode)n);
                initMethodReturnType = StaticJavaParser.parseClassOrInterfaceType((String)AbstractCompilerHandler.getVariableType((AlphaNode)n).getCanonicalName());
            } else {
                variableName = AbstractCompilerHandler.getVariableName((Sink)n);
                initMethodReturnType = StaticJavaParser.parseClassOrInterfaceType((String)AbstractCompilerHandler.getVariableType((Sink)n).getCanonicalName());
            }
            String initMethodName = String.format("init%s", variableName);
            MethodDeclaration initMethod = new MethodDeclaration(NodeList.nodeList((Node[])new Modifier[]{Modifier.publicModifier(), Modifier.staticModifier()}), initMethodName, (Type)initMethodReturnType, this.parametersFromAdditionalFields());
            Expression initExpressionForNode = ((CanInlineInANC)n).toANCInlinedForm();
            partitionedClass.addMember((BodyDeclaration)initMethod);
            BlockStmt initMethodBlock = new BlockStmt();
            initMethodBlock.addStatement((Statement)new ReturnStmt(initExpressionForNode));
            initMethod.setBody(initMethodBlock);
            String callInitMethodAndAssignToFieldString = String.format("%s = %s.%s.%s(ctx);", variableName, partitionedClassPackage.getNameAsString(), partitionedClass.getNameAsString(), initMethodName);
            initBodyPerPartition.addStatement(StaticJavaParser.parseStatement((String)callInitMethodAndAssignToFieldString));
        }
    }

    private NodeList<Parameter> parametersFromAdditionalFields() {
        List parameters = this.additionalFields.stream().map(f -> new Parameter(f.getCommonType(), ((VariableDeclarator)f.getVariables().get(0)).toString())).collect(Collectors.toList());
        return NodeList.nodeList(parameters);
    }
}

