/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.WorkingMemory;
import org.drools.agent.ResourceDiffProducer;
import org.drools.agent.impl.ResourceDiffResult;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.definition.KnowledgeDefinition;
import org.drools.definition.rule.Rule;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.rule.Function;
import org.drools.rule.Query;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryResourceDiffProducerImpl
extends ReflectiveVisitor
implements ResourceDiffProducer {
    private KnowledgePackageImp newPkg;
    private KnowledgePackageImp currentPkg;
    private Set<KnowledgeDefinition> unmodifiedDefinitions = new HashSet<KnowledgeDefinition>();
    private Set<KnowledgeDefinition> removedDefinitions = new HashSet<KnowledgeDefinition>();
    private SystemEventListener listener;
    private Calendar now = new GregorianCalendar();
    private Consequence dummyConsequence = new DummyConsequence();

    @Override
    public ResourceDiffResult diff(Set<KnowledgeDefinition> originalDefinitions, KnowledgePackageImp newPkg, KnowledgePackageImp currentPkg) {
        this.listener = SystemEventListenerFactory.getSystemEventListener();
        this.newPkg = newPkg;
        this.currentPkg = currentPkg;
        for (KnowledgeDefinition knowledgeDefinition : originalDefinitions) {
            this.visit(knowledgeDefinition);
        }
        return new ResourceDiffResult(this.newPkg, this.unmodifiedDefinitions, this.removedDefinitions);
    }

    public void visitRule(org.drools.rule.Rule oldRule) {
        Rule newRule = this.newPkg.getRule(oldRule.getName());
        if (newRule == null) {
            this.listener.debug("BinaryResourceDiffProducerImpl: " + oldRule + " is not present anymore. Adding to removed list.");
            this.removedDefinitions.add((KnowledgeDefinition)oldRule);
            return;
        }
        if (this.currentPkg.getRule(oldRule.getName()) == null) {
            this.listener.debug("BinaryResourceDiffProducerImpl: " + oldRule + " is not present on current PKG. Removing from new package.");
            this.newPkg.removeRule(oldRule);
            return;
        }
        if (!(newRule instanceof org.drools.rule.Rule)) {
            this.listener.warning("BinaryResourceDiffProducerImpl: Rules must be subclasses of org.drools.rule.Rule.");
            return;
        }
        if (newRule instanceof Query) {
            this.listener.debug("BinaryResourceDiffProducerImpl: Query diff is not supported yet.");
            return;
        }
        if (this.compareRules((org.drools.rule.Rule)newRule, oldRule)) {
            this.listener.debug("BinaryResourceDiffProducerImpl: " + oldRule + " didn't change. Removing from diff package and adding it to unmodified list.");
            this.newPkg.removeRule((org.drools.rule.Rule)newRule);
            this.unmodifiedDefinitions.add((KnowledgeDefinition)oldRule);
        }
    }

    public void visitFunction(Function oldFunction) {
        Function newFunction = this.newPkg.getFunction(oldFunction.getName());
        if (newFunction == null) {
            this.listener.debug("BinaryResourceDiffProducerImpl: " + oldFunction + " is not present anymore. Adding to removed list.");
            this.removedDefinitions.add(oldFunction);
            return;
        }
        if (this.currentPkg.getFunction(oldFunction.getName()) == null) {
            this.listener.debug("BinaryResourceDiffProducerImpl: " + oldFunction + " is not present on current PKG. Removing from new package.");
            this.newPkg.removeFunction(oldFunction.getName());
            return;
        }
        if (newFunction.equals(oldFunction)) {
            this.listener.debug("BinaryResourceDiffProducerImpl: " + oldFunction + " didn't change. Removing from diff package and adding it to unmodified list.");
            this.newPkg.removeFunction(newFunction.getName());
            this.unmodifiedDefinitions.add(oldFunction);
        } else {
            this.listener.debug("BinaryResourceDiffProducerImpl: " + oldFunction + " did change. Marking as removed so it new version could be added later.");
            this.removedDefinitions.add(oldFunction);
        }
    }

    public void visitKnowledgeDefinition(KnowledgeDefinition oldDefinition) {
        this.listener.debug("BinaryResourceDiffProducerImpl: Couldn't handle " + oldDefinition + ". We must leave it in the new Package.");
    }

    private boolean compareRules(org.drools.rule.Rule r1, org.drools.rule.Rule r2) {
        Consequence consequence2;
        Calendar c2;
        String v2;
        this.listener.debug("BinaryResourceDiffProducerImpl: Comparing " + r1 + " against " + r2);
        String v1 = r1.getSalience() == null ? "" : r1.getSalience().toString();
        String string = v2 = r2.getSalience() == null ? "" : r2.getSalience().toString();
        if (!v1.equals(v2)) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different saliences: r1= " + v1 + ", r2= " + v2);
            return false;
        }
        v1 = r1.getActivationGroup() == null ? "" : r1.getActivationGroup();
        String string2 = v2 = r2.getActivationGroup() == null ? "" : r2.getActivationGroup();
        if (!v1.equals(v2)) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different activation groups: r1= " + v1 + ", r2= " + v2);
            return false;
        }
        if (r1.isNoLoop() != r2.isNoLoop()) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different values for no-loop attribure: r1= " + r1.isNoLoop() + ", r2= " + r2.isNoLoop());
            return false;
        }
        if (r1.isLockOnActive() != r2.isLockOnActive()) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different values for lock-on-active attribure: r1= " + r1.isLockOnActive() + ", r2= " + r2.isLockOnActive());
            return false;
        }
        v1 = r1.getAgendaGroup() == null ? "" : r1.getAgendaGroup();
        String string3 = v2 = r2.getAgendaGroup() == null ? "" : r2.getAgendaGroup();
        if (!v1.equals(v2)) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different agenda groups: r1= " + v1 + ", r2= " + v2);
            return false;
        }
        if (r1.getAutoFocus() != r2.getAutoFocus()) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different values for auto-focus attribure: r1= " + r1.getAutoFocus() + ", r2= " + r2.getAutoFocus());
            return false;
        }
        v1 = r1.getRuleFlowGroup() == null ? "" : r1.getRuleFlowGroup();
        String string4 = v2 = r2.getRuleFlowGroup() == null ? "" : r2.getRuleFlowGroup();
        if (!v1.equals(v2)) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different ruleflow-group attribute: r1= " + v1 + ", r2= " + v2);
            return false;
        }
        v1 = r1.getDialect() == null ? "" : r1.getDialect();
        String string5 = v2 = r2.getDialect() == null ? "" : r2.getDialect();
        if (!v1.equals(v2)) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different dialect attribute: r1= " + v1 + ", r2= " + v2);
            return false;
        }
        Calendar c1 = r1.getDateEffective() == null ? this.now : r1.getDateEffective();
        Calendar calendar = c2 = r2.getDateEffective() == null ? this.now : r2.getDateEffective();
        if (!c1.equals(c2)) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different date-effective attribute: r1= " + c1 + ", r2= " + c2);
            return false;
        }
        c1 = r1.getDateExpires() == null ? this.now : r1.getDateExpires();
        Calendar calendar2 = c2 = r2.getDateExpires() == null ? this.now : r2.getDateExpires();
        if (!c1.equals(c2)) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different date-expires attribute: r1= " + c1 + ", r2= " + c2);
            return false;
        }
        if (!r1.getLhs().equals(r2.getLhs())) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different LHS");
            return false;
        }
        Consequence consequence1 = r1.getConsequence() == null ? this.dummyConsequence : r1.getConsequence();
        Consequence consequence = consequence2 = r2.getConsequence() == null ? this.dummyConsequence : r2.getConsequence();
        if (!consequence1.equals(consequence2)) {
            this.listener.debug("BinaryResourceDiffProducerImpl: The rules have different Consequences: r1= " + consequence1 + ", r2= " + consequence2);
            return false;
        }
        return true;
    }

    private class DummyConsequence
    implements Consequence {
        private DummyConsequence() {
        }

        public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            throw new UnsupportedOperationException("You should never call this method!!");
        }

        public String getName() {
            return "default";
        }
    }
}

