/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.command.Context;
import org.drools.command.ContextManager;
import org.drools.command.impl.ContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextImplWithEviction
extends ContextImpl {
    private Logger log = Logger.getLogger(ContextImplWithEviction.class.getName());
    private Map<String, Long> evictionMap = new ConcurrentHashMap<String, Long>();
    private boolean evictionEnabled = true;
    private long evictionWakeUpTime = 300000L;
    private long entryEvictionTime = 3600000L;

    public ContextImplWithEviction(String name, ContextManager manager, Context delegate) {
        super(name, manager, delegate);
    }

    public ContextImplWithEviction(String name, ContextManager manager) {
        super(name, manager);
    }

    @Override
    public Object get(String identifier) {
        Object result = super.get(identifier);
        if (this.evictionEnabled && identifier != null && result != null) {
            long currentTimeStamp = System.currentTimeMillis();
            this.evictionMap.put(identifier, currentTimeStamp);
            this.log.log(Level.FINE, "Updating key=" + identifier + "@" + super.getName() + ":" + currentTimeStamp);
        }
        return result;
    }

    @Override
    public void set(String name, Object object) {
        if (this.evictionEnabled) {
            long currentTimeStamp = System.currentTimeMillis();
            this.evictionMap.put(name, currentTimeStamp);
            this.log.log(Level.FINE, "Setting key=" + name + "@" + super.getName() + ":" + currentTimeStamp);
        }
        super.set(name, object);
    }

    public long getEvictionWakeUpTime() {
        return this.evictionWakeUpTime;
    }

    public Map<String, Long> getEvictionMap() {
        return this.evictionMap;
    }

    public boolean isEvictionEnabled() {
        return this.evictionEnabled;
    }

    public void setEvictionEnabled(boolean evictionEnabled) {
        this.evictionEnabled = evictionEnabled;
    }

    public long getEntryEvictionTime() {
        return this.entryEvictionTime;
    }

    public void setEntryEvictionTime(long entryEvictionTime) {
        this.entryEvictionTime = entryEvictionTime;
    }

    public void setEvictionWakeUpTime(long evictionWakeUpTime) {
        this.evictionWakeUpTime = evictionWakeUpTime;
    }
}

