/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import org.drools.RuntimeDroolsException;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBuilder {
    private boolean debug = false;

    public ClassBuilder() {
        this("true".equalsIgnoreCase(System.getProperty("org.drools.classbuilder.debug")));
    }

    public ClassBuilder(boolean debug) {
        this.debug = debug;
    }

    public byte[] buildClass(ClassDefinition classDef) throws IOException, IntrospectionException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        ClassWriter cw = new ClassWriter(3);
        this.buildClassHeader((ClassVisitor)cw, classDef);
        for (FieldDefinition fieldDef : classDef.getFieldsDefinitions()) {
            if (fieldDef.isInherited()) continue;
            this.buildField((ClassVisitor)cw, fieldDef);
        }
        this.buildDefaultConstructor((ClassVisitor)cw, classDef);
        if (classDef.getFieldsDefinitions().size() > 0) {
            this.buildConstructorWithFields((ClassVisitor)cw, classDef, classDef.getFieldsDefinitions());
        }
        LinkedList<FieldDefinition> keys = new LinkedList<FieldDefinition>();
        for (FieldDefinition fieldDef : classDef.getFieldsDefinitions()) {
            if (!fieldDef.isKey()) continue;
            keys.add(fieldDef);
        }
        if (!keys.isEmpty() && keys.size() != classDef.getFieldsDefinitions().size()) {
            this.buildConstructorWithFields((ClassVisitor)cw, classDef, keys);
        }
        for (FieldDefinition fieldDef : classDef.getFieldsDefinitions()) {
            if (fieldDef.isInherited()) continue;
            this.buildGetMethod((ClassVisitor)cw, classDef, fieldDef);
            this.buildSetMethod((ClassVisitor)cw, classDef, fieldDef);
        }
        this.buildEquals((ClassVisitor)cw, classDef);
        this.buildHashCode((ClassVisitor)cw, classDef);
        this.buildToString((ClassVisitor)cw, classDef);
        cw.visitEnd();
        byte[] serializedClass = cw.toByteArray();
        return serializedClass;
    }

    private void buildClassHeader(ClassVisitor cw, ClassDefinition classDef) {
        String[] original = classDef.getInterfaces();
        String[] interfaces = new String[original.length];
        for (int i = 0; i < original.length; ++i) {
            interfaces[i] = this.getInternalType(original[i]);
        }
        cw.visit(49, 33, this.getInternalType(classDef.getClassName()), null, this.getInternalType(classDef.getSuperClass()), interfaces);
        cw.visitSource(classDef.getClassName() + ".java", null);
    }

    private void buildField(ClassVisitor cw, FieldDefinition fieldDef) {
        FieldVisitor fv = cw.visitField(2, fieldDef.getName(), this.getTypeDescriptor(fieldDef.getTypeName()), null, null);
        fv.visitEnd();
    }

    private void buildDefaultConstructor(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        String sup = "";
        try {
            sup = Type.getInternalName(Class.forName(classDef.getSuperClass()));
        }
        catch (ClassNotFoundException e) {
            sup = this.getInternalType(classDef.getSuperClass());
        }
        mv.visitMethodInsn(183, sup, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            Object val;
            if (field.isInherited() || (val = this.getDefaultValue(field)) == null) continue;
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(val);
            if (this.isBoxed(field.getTypeName())) {
                mv.visitMethodInsn(184, this.getInternalType(field.getTypeName()), "valueOf", "(" + this.unBox(field.getTypeName()) + ")" + this.getTypeDescriptor(field.getTypeName()));
            }
            mv.visitFieldInsn(181, this.getInternalType(classDef.getClassName()), field.getName(), this.getTypeDescriptor(field.getTypeName()));
        }
        mv.visitInsn(177);
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", this.getTypeDescriptor(classDef.getClassName()), null, l0, l1, 0);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildConstructorWithFields(ClassVisitor cw, ClassDefinition classDef, Collection<FieldDefinition> fieldDefs) {
        Type[] params = new Type[fieldDefs.size()];
        int index = 0;
        for (FieldDefinition field : fieldDefs) {
            params[index++] = Type.getType((String)this.getTypeDescriptor(field.getTypeName()));
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])params), null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        String sup = "";
        try {
            sup = Type.getInternalName(Class.forName(classDef.getSuperClass()));
        }
        catch (ClassNotFoundException e) {
            sup = this.getInternalType(classDef.getSuperClass());
        }
        mv.visitMethodInsn(183, sup, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        index = 1;
        for (FieldDefinition field : fieldDefs) {
            if (this.debug) {
                Label l11 = new Label();
                mv.visitLabel(l11);
            }
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(Type.getType((String)this.getTypeDescriptor(field.getTypeName())).getOpcode(21), index++);
            if (field.getTypeName().equals("long") || field.getTypeName().equals("double")) {
                ++index;
            }
            if (!field.isInherited()) {
                mv.visitFieldInsn(181, this.getInternalType(classDef.getClassName()), field.getName(), this.getTypeDescriptor(field.getTypeName()));
                continue;
            }
            mv.visitMethodInsn(182, this.getInternalType(classDef.getClassName()), field.getWriteMethod(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)this.getTypeDescriptor(field.getTypeName()))}));
        }
        mv.visitInsn(177);
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", this.getTypeDescriptor(classDef.getClassName()), null, l0, l1, 0);
            for (FieldDefinition field : classDef.getFieldsDefinitions()) {
                Label l11 = new Label();
                mv.visitLabel(l11);
                mv.visitLocalVariable(field.getName(), this.getTypeDescriptor(field.getTypeName()), null, l0, l1, 0);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildSetMethod(ClassVisitor cw, ClassDefinition classDef, FieldDefinition fieldDef) {
        MethodVisitor mv = cw.visitMethod(1, fieldDef.getWriteMethod(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)this.getTypeDescriptor(fieldDef.getTypeName()))}), null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(Type.getType((String)this.getTypeDescriptor(fieldDef.getTypeName())).getOpcode(21), 1);
        mv.visitFieldInsn(181, this.getInternalType(classDef.getClassName()), fieldDef.getName(), this.getTypeDescriptor(fieldDef.getTypeName()));
        mv.visitInsn(177);
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", this.getTypeDescriptor(classDef.getClassName()), null, l0, l1, 0);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildGetMethod(ClassVisitor cw, ClassDefinition classDef, FieldDefinition fieldDef) {
        MethodVisitor mv = cw.visitMethod(1, fieldDef.getReadMethod(), Type.getMethodDescriptor((Type)Type.getType((String)this.getTypeDescriptor(fieldDef.getTypeName())), (Type[])new Type[0]), null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getInternalType(classDef.getClassName()), fieldDef.getName(), this.getTypeDescriptor(fieldDef.getTypeName()));
        mv.visitInsn(Type.getType((String)this.getTypeDescriptor(fieldDef.getTypeName())).getOpcode(172));
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", this.getTypeDescriptor(classDef.getClassName()), null, l0, l1, 0);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildEquals(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(166, l1);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 1);
        Label l2 = new Label();
        mv.visitJumpInsn(199, l2);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]));
        Label l3 = new Label();
        mv.visitJumpInsn(165, l3);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l3);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.getInternalType(classDef.getClassName()));
        mv.visitVarInsn(58, 2);
        int count = 0;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            ++count;
            Label goNext = new Label();
            if (this.isPrimitive(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitVarInsn(25, 2);
                this.visitFieldOrGetter(mv, classDef, field);
                if (field.getTypeName().equals("long")) {
                    mv.visitInsn(148);
                    mv.visitJumpInsn(153, goNext);
                } else if (field.getTypeName().equals("double")) {
                    mv.visitInsn(151);
                    mv.visitJumpInsn(153, goNext);
                } else if (field.getTypeName().equals("float")) {
                    mv.visitInsn(149);
                    mv.visitJumpInsn(153, goNext);
                } else {
                    mv.visitJumpInsn(159, goNext);
                }
                mv.visitInsn(3);
                mv.visitInsn(172);
            } else {
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                Label secondIfPart = new Label();
                mv.visitJumpInsn(199, secondIfPart);
                mv.visitVarInsn(25, 2);
                this.visitFieldOrGetter(mv, classDef, field);
                Label returnFalse = new Label();
                mv.visitJumpInsn(199, returnFalse);
                mv.visitLabel(secondIfPart);
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitJumpInsn(198, goNext);
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitVarInsn(25, 2);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitMethodInsn(182, this.getInternalType(field.getTypeName()), "equals", "(Ljava/lang/Object;)Z");
                mv.visitJumpInsn(154, goNext);
                mv.visitLabel(returnFalse);
                mv.visitInsn(3);
                mv.visitInsn(172);
            }
            mv.visitLabel(goNext);
        }
        if (count > 0) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitInsn(172);
        Label lastLabel = null;
        if (this.debug) {
            lastLabel = new Label();
            mv.visitLabel(lastLabel);
            mv.visitLocalVariable("this", this.getTypeDescriptor(classDef.getClassName()), null, l0, lastLabel, 0);
            mv.visitLocalVariable("obj", Type.getDescriptor(Object.class), null, l0, lastLabel, 1);
            mv.visitLocalVariable("other", this.getTypeDescriptor(classDef.getClassName()), null, l0, lastLabel, 2);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildHashCode(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitInsn(4);
        mv.visitVarInsn(54, 1);
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            mv.visitVarInsn(21, 1);
            mv.visitIntInsn(16, 31);
            mv.visitVarInsn(21, 1);
            mv.visitInsn(104);
            mv.visitVarInsn(25, 0);
            this.visitFieldOrGetter(mv, classDef, field);
            if ("boolean".equals(field.getTypeName())) {
                Label blabel1 = new Label();
                mv.visitJumpInsn(153, blabel1);
                mv.visitIntInsn(17, 1231);
                Label blabel2 = new Label();
                mv.visitJumpInsn(167, blabel2);
                mv.visitLabel(blabel1);
                mv.visitIntInsn(17, 1237);
                mv.visitLabel(blabel2);
            } else if ("long".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
            } else if ("float".equals(field.getTypeName())) {
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "floatToIntBits", "(F)I");
            } else if ("double".equals(field.getTypeName())) {
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "doubleToLongBits", "(D)J");
                mv.visitInsn(92);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
            } else if (!this.isPrimitive(field.getTypeName())) {
                Label olabel1 = new Label();
                mv.visitJumpInsn(199, olabel1);
                mv.visitInsn(3);
                Label olabel2 = new Label();
                mv.visitJumpInsn(167, olabel2);
                mv.visitLabel(olabel1);
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitMethodInsn(182, this.getInternalType(field.getTypeName()), "hashCode", "()I");
                mv.visitLabel(olabel2);
            }
            mv.visitInsn(96);
            mv.visitVarInsn(54, 1);
        }
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        Label lastLabel = null;
        if (this.debug) {
            lastLabel = new Label();
            mv.visitLabel(lastLabel);
            mv.visitLocalVariable("this", this.getTypeDescriptor(classDef.getClassName()), null, l0, lastLabel, 0);
            mv.visitLocalVariable("hash", Type.getDescriptor(Integer.TYPE), null, l0, lastLabel, 1);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildToString(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", "()V");
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.getInternalType(classDef.getClassName()), "getClass", "()Ljava/lang/Class;");
        mv.visitMethodInsn(182, Type.getInternalName(Class.class), "getSimpleName", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitLdcInsn((Object)"( ");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        boolean previous = false;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (previous) {
                mv.visitLdcInsn((Object)", ");
                mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            }
            mv.visitLdcInsn((Object)field.getName());
            mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            mv.visitLdcInsn((Object)"=");
            mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            mv.visitVarInsn(25, 0);
            this.visitFieldOrGetter(mv, classDef, field);
            if (this.isPrimitive(field.getTypeName())) {
                String type = field.getTypeName().matches("(byte|short)") ? "int" : field.getTypeName();
                mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType((String)this.getTypeDescriptor(type))}));
            } else {
                mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(Object.class)}));
            }
            previous = true;
        }
        mv.visitLdcInsn((Object)" )");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "toString", "()Ljava/lang/String;");
        mv.visitInsn(176);
        Label lastLabel = null;
        if (this.debug) {
            lastLabel = new Label();
            mv.visitLabel(lastLabel);
            mv.visitLocalVariable("this", this.getTypeDescriptor(classDef.getClassName()), null, l0, lastLabel, 0);
            mv.visitLocalVariable("buf", Type.getDescriptor(StringBuilder.class), null, l0, lastLabel, 1);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private String getInternalType(String type) {
        String internalType = null;
        if ("byte".equals(type)) {
            internalType = "B";
        } else if ("char".equals(type)) {
            internalType = "C";
        } else if ("double".equals(type)) {
            internalType = "D";
        } else if ("float".equals(type)) {
            internalType = "F";
        } else if ("int".equals(type)) {
            internalType = "I";
        } else if ("long".equals(type)) {
            internalType = "J";
        } else if ("short".equals(type)) {
            internalType = "S";
        } else if ("boolean".equals(type)) {
            internalType = "Z";
        } else if ("void".equals(type)) {
            internalType = "V";
        } else if (type != null) {
            internalType = type.replace('.', '/');
        }
        return internalType;
    }

    private String getTypeDescriptor(String type) {
        String internalType = null;
        if ("byte".equals(type)) {
            internalType = "B";
        } else if ("char".equals(type)) {
            internalType = "C";
        } else if ("double".equals(type)) {
            internalType = "D";
        } else if ("float".equals(type)) {
            internalType = "F";
        } else if ("int".equals(type)) {
            internalType = "I";
        } else if ("long".equals(type)) {
            internalType = "J";
        } else if ("short".equals(type)) {
            internalType = "S";
        } else if ("boolean".equals(type)) {
            internalType = "Z";
        } else if ("void".equals(type)) {
            internalType = "V";
        } else if (type != null) {
            internalType = "L" + type.replace('.', '/') + ";";
        }
        return internalType;
    }

    private boolean isPrimitive(String type) {
        boolean isPrimitive = false;
        if ("byte".equals(type) || "char".equals(type) || "double".equals(type) || "float".equals(type) || "int".equals(type) || "long".equals(type) || "short".equals(type) || "boolean".equals(type) || "void".equals(type)) {
            isPrimitive = true;
        }
        return isPrimitive;
    }

    private void visitFieldOrGetter(MethodVisitor mv, ClassDefinition classDef, FieldDefinition field) {
        if (!field.isInherited()) {
            mv.visitFieldInsn(180, this.getInternalType(classDef.getClassName()), field.getName(), this.getTypeDescriptor(field.getTypeName()));
        } else {
            mv.visitMethodInsn(182, this.getInternalType(classDef.getClassName()), field.getReadMethod(), Type.getMethodDescriptor((Type)Type.getType((String)this.getTypeDescriptor(field.getTypeName())), (Type[])new Type[0]));
        }
    }

    private Object getDefaultValue(FieldDefinition fld) {
        String type = fld.getTypeName();
        if ("byte".equals(type)) {
            return fld.getDefaultValueAs_byte();
        }
        if ("char".equals(type)) {
            return Character.valueOf(fld.getDefaultValueAs_char());
        }
        if ("double".equals(type)) {
            return fld.getDefaultValueAs_double();
        }
        if ("float".equals(type)) {
            return Float.valueOf(fld.getDefaultValueAs_float());
        }
        if ("int".equals(type)) {
            return fld.getDefaultValueAs_int();
        }
        if ("long".equals(type)) {
            return fld.getDefaultValueAs_long();
        }
        if ("short".equals(type)) {
            return fld.getDefaultValueAs_short();
        }
        if ("boolean".equals(type)) {
            return fld.getDefaultValueAs_boolean();
        }
        if ("java.lang.String".equals(type)) {
            return fld.getDefaultValueAsString();
        }
        if ("java.lang.Byte".equals(type) || "Byte".equals(type)) {
            return fld.getDefaultValueAsByte();
        }
        if ("java.lang.Character".equals(type) || "Character".equals(type)) {
            return fld.getDefaultValueAsChar();
        }
        if ("java.lang.Double".equals(type) || "Double".equals(type)) {
            return fld.getDefaultValueAsDouble();
        }
        if ("java.lang.Float".equals(type) || "Float".equals(type)) {
            return fld.getDefaultValueAsFloat();
        }
        if ("java.lang.Integer".equals(type) || "Integer".equals(type)) {
            return fld.getDefaultValueAsInt();
        }
        if ("java.lang.Long".equals(type) || "Long".equals(type)) {
            return fld.getDefaultValueAsLong();
        }
        if ("java.lang.Short".equals(type) || "Short".equals(type)) {
            return fld.getDefaultValueAsShort();
        }
        if ("java.lang.Boolean".equals(type) || "Boolean".equals(type)) {
            return fld.getDefaultValueAsBoolean();
        }
        return null;
    }

    private boolean isBoxed(String type) {
        if (type == null) {
            return false;
        }
        return "java.lang.Short".equals(type) || "java.lang.Byte".equals(type) || "java.lang.Character".equals(type) || "java.lang.Double".equals(type) || "java.lang.Float".equals(type) || "java.lang.Integer".equals(type) || "java.lang.Boolean".equals(type) || "java.lang.Long".equals(type);
    }

    private String unBox(String type) {
        if ("java.lang.Byte".equals(type) || "Byte".equals(type)) {
            return this.getInternalType("byte");
        }
        if ("java.lang.Character".equals(type) || "Character".equals(type)) {
            return this.getInternalType("char");
        }
        if ("java.lang.Double".equals(type) || "Double".equals(type)) {
            return this.getInternalType("double");
        }
        if ("java.lang.Float".equals(type) || "Float".equals(type)) {
            return this.getInternalType("float");
        }
        if ("java.lang.Integer".equals(type) || "Integer".equals(type)) {
            return this.getInternalType("int");
        }
        if ("java.lang.Long".equals(type) || "Long".equals(type)) {
            return this.getInternalType("long");
        }
        if ("java.lang.Short".equals(type) || "Short".equals(type)) {
            return this.getInternalType("short");
        }
        if ("java.lang.Boolean".equals(type) || "Boolean".equals(type)) {
            return this.getInternalType("boolean");
        }
        throw new RuntimeDroolsException("Unable to recognize boxed primitive type " + type);
    }
}

