/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.EnabledBoolean;
import org.drools.core.base.SalienceInteger;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.ConditionalBranch;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Forall;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.MultiAccumulate;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.rule.NamedConsequence;
import org.drools.core.rule.PatternSource;
import org.drools.core.rule.QueryArgument;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.QueryImpl;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.SingleAccumulate;
import org.drools.core.rule.SlidingLengthWindow;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.rule.constraint.QueryNameConstraint;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.Enabled;
import org.drools.core.spi.EvalExpression;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.Salience;
import org.drools.core.time.impl.Timer;
import org.drools.model.AccumulatePattern;
import org.drools.model.Argument;
import org.drools.model.Binding;
import org.drools.model.Condition;
import org.drools.model.Consequence;
import org.drools.model.Constraint;
import org.drools.model.DSL;
import org.drools.model.Declaration;
import org.drools.model.DeclarationSource;
import org.drools.model.EntryPoint;
import org.drools.model.From;
import org.drools.model.Global;
import org.drools.model.Index;
import org.drools.model.Model;
import org.drools.model.Pattern;
import org.drools.model.Query;
import org.drools.model.Rule;
import org.drools.model.SingleConstraint;
import org.drools.model.Type;
import org.drools.model.TypeMetaData;
import org.drools.model.UnitData;
import org.drools.model.Value;
import org.drools.model.Variable;
import org.drools.model.View;
import org.drools.model.WindowDefinition;
import org.drools.model.WindowReference;
import org.drools.model.consequences.ConditionalNamedConsequenceImpl;
import org.drools.model.consequences.NamedConsequenceImpl;
import org.drools.model.constraints.SingleConstraint1;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.model.impl.DeclarationImpl;
import org.drools.model.impl.NamesGenerator;
import org.drools.model.patterns.CompositePatterns;
import org.drools.model.patterns.EvalImpl;
import org.drools.model.patterns.PatternImpl;
import org.drools.model.patterns.QueryCallPattern;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.drools.modelcompiler.ModelCompilerUtil;
import org.drools.modelcompiler.RuleContext;
import org.drools.modelcompiler.consequence.LambdaConsequence;
import org.drools.modelcompiler.consequence.MVELConsequence;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaAccumulator;
import org.drools.modelcompiler.constraints.LambdaConstraint;
import org.drools.modelcompiler.constraints.LambdaDataProvider;
import org.drools.modelcompiler.constraints.LambdaEvalExpression;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;
import org.drools.modelcompiler.constraints.TemporalConstraintEvaluator;
import org.drools.modelcompiler.constraints.UnificationConstraint;
import org.drools.modelcompiler.util.TypeDeclarationUtil;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.type.Role;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.utils.ChainedProperties;
import org.kie.soup.project.datamodel.commons.types.ClassTypeResolver;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class KiePackagesBuilder {
    private final RuleBaseConfiguration configuration;
    private final Map<String, KiePackage> packages = new HashMap<String, KiePackage>();
    private final Map<Class<?>, ClassObjectType> objectTypeCache = new HashMap();
    private final Collection<Model> models;
    private final ChainedProperties chainedProperties;

    public KiePackagesBuilder(KieBaseConfiguration conf, ProjectClassLoader moduleClassLoader) {
        this(conf, new ArrayList<Model>(), moduleClassLoader);
    }

    public KiePackagesBuilder(KieBaseConfiguration conf, Collection<Model> models, ProjectClassLoader moduleClassLoader) {
        this.configuration = (RuleBaseConfiguration)conf;
        this.models = models;
        this.chainedProperties = ChainedProperties.getChainedProperties((ClassLoader)moduleClassLoader.getTypesClassLoader());
    }

    public void addModel(Model model) {
        this.models.add(model);
    }

    public CanonicalKiePackages build() {
        for (Model model : this.models) {
            KnowledgePackageImpl pkg;
            for (TypeMetaData metaType : model.getTypeMetaDatas()) {
                pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(metaType.getPackage(), this::createKiePackage);
                pkg.addTypeDeclaration(TypeDeclarationUtil.createTypeDeclaration(pkg, metaType));
            }
            for (Global global : model.getGlobals()) {
                pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(global.getPackage(), this::createKiePackage);
                pkg.addGlobal(global.getName(), global.getType().asClass());
            }
            for (Query query : model.getQueries()) {
                pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(query.getPackage(), this::createKiePackage);
                pkg.addRule((RuleImpl)this.compileQuery(pkg, query));
            }
            int ruleCounter = 0;
            for (Rule rule : model.getRules()) {
                KnowledgePackageImpl pkg2 = (KnowledgePackageImpl)this.packages.computeIfAbsent(rule.getPackage(), this::createKiePackage);
                RuleImpl ruleImpl = this.compileRule(pkg2, rule);
                ruleImpl.setLoadOrder(ruleCounter++);
                pkg2.addRule(ruleImpl);
            }
        }
        return new CanonicalKiePackages(this.packages);
    }

    private KnowledgePackageImpl createKiePackage(String name) {
        KnowledgePackageImpl kpkg = new KnowledgePackageImpl(name);
        kpkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(this.configuration.getClassLoader()));
        ClassTypeResolver typeResolver = new ClassTypeResolver(new HashSet(kpkg.getImports().keySet()), this.configuration.getClassLoader(), name);
        typeResolver.addImport(name + ".*");
        kpkg.setTypeResolver((TypeResolver)typeResolver);
        return kpkg;
    }

    private RuleImpl compileRule(KnowledgePackageImpl pkg, Rule rule) {
        RuleImpl ruleImpl = new RuleImpl(rule.getName());
        ruleImpl.setPackage(pkg.getName());
        this.setRuleAttributes(rule, ruleImpl);
        this.setRuleMetaAttributes(rule, ruleImpl);
        ruleImpl.setPackage(rule.getPackage());
        if (rule.getUnit() != null) {
            ruleImpl.setRuleUnitClassName(rule.getUnit());
            pkg.getRuleUnitRegistry().getRuleUnitFor(ruleImpl);
        }
        RuleContext ctx = new RuleContext(this, pkg, ruleImpl);
        this.populateLHS(ctx, pkg, rule.getView());
        this.processConsequences(ctx, rule);
        return ruleImpl;
    }

    private void setRuleAttributes(Rule rule, RuleImpl ruleImpl) {
        Boolean noLoop = this.setAttribute(rule, Rule.Attribute.NO_LOOP, arg_0 -> ((RuleImpl)ruleImpl).setNoLoop(arg_0));
        Boolean lockOnActive = this.setAttribute(rule, Rule.Attribute.LOCK_ON_ACTIVE, arg_0 -> ((RuleImpl)ruleImpl).setLockOnActive(arg_0));
        this.setAttribute(rule, Rule.Attribute.AUTO_FOCUS, arg_0 -> ((RuleImpl)ruleImpl).setAutoFocus(arg_0));
        this.setAttribute(rule, Rule.Attribute.ENABLED, e -> ruleImpl.setEnabled((Enabled)new EnabledBoolean(e.booleanValue())));
        this.setAttribute(rule, Rule.Attribute.SALIENCE, s -> ruleImpl.setSalience((Salience)new SalienceInteger(s.intValue())));
        String agendaGroup = this.setAttribute(rule, Rule.Attribute.AGENDA_GROUP, arg_0 -> ((RuleImpl)ruleImpl).setAgendaGroup(arg_0));
        this.setAttribute(rule, Rule.Attribute.RULEFLOW_GROUP, rfg -> {
            ruleImpl.setRuleFlowGroup(rfg);
            if (agendaGroup == null) {
                ruleImpl.setAgendaGroup(rfg);
            }
        });
        this.setAttribute(rule, Rule.Attribute.ACTIVATION_GROUP, arg_0 -> ((RuleImpl)ruleImpl).setActivationGroup(arg_0));
        this.setAttribute(rule, Rule.Attribute.DURATION, t -> ruleImpl.setTimer(this.parseTimer((String)t)));
        this.setAttribute(rule, Rule.Attribute.TIMER, t -> ruleImpl.setTimer(this.parseTimer((String)t)));
        this.setAttribute(rule, Rule.Attribute.CALENDARS, arg_0 -> ((RuleImpl)ruleImpl).setCalendars(arg_0));
        this.setAttribute(rule, Rule.Attribute.DATE_EFFECTIVE, arg_0 -> ((RuleImpl)ruleImpl).setDateEffective(arg_0));
        this.setAttribute(rule, Rule.Attribute.DATE_EXPIRES, arg_0 -> ((RuleImpl)ruleImpl).setDateExpires(arg_0));
        ruleImpl.setEager(ruleImpl.isEager() || noLoop != null || lockOnActive != null);
    }

    private <T> T setAttribute(Rule rule, Rule.Attribute<T> attribute, Consumer<T> consumer) {
        Object value = rule.getAttribute(attribute);
        if (value != attribute.getDefaultValue()) {
            consumer.accept(value);
            return (T)value;
        }
        return null;
    }

    private void setRuleMetaAttributes(Rule rule, RuleImpl ruleImpl) {
        for (Map.Entry kv : rule.getMetaData().entrySet()) {
            ruleImpl.addMetaAttribute((String)kv.getKey(), kv.getValue());
        }
    }

    private Timer parseTimer(String s) {
        throw new UnsupportedOperationException();
    }

    private QueryImpl compileQuery(KnowledgePackageImpl pkg, Query query) {
        QueryImpl queryImpl = new QueryImpl(query.getName());
        queryImpl.setPackage(query.getPackage());
        RuleContext ctx = new RuleContext(this, pkg, (RuleImpl)queryImpl);
        this.addQueryPattern(query, queryImpl, ctx);
        this.populateLHS(ctx, pkg, query.getView());
        return queryImpl;
    }

    private void addQueryPattern(Query query, QueryImpl queryImpl, RuleContext ctx) {
        org.drools.core.rule.Pattern pattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), 0, (ObjectType)ClassObjectType.DroolsQuery_ObjectType, null);
        LambdaReadAccessor extractor = new LambdaReadAccessor(DroolsQuery.class, (Function1 & Serializable)q -> ((DroolsQuery)q).getName());
        QueryNameConstraint constraint = new QueryNameConstraint((InternalReadAccessor)extractor, query.getName());
        pattern.addConstraint((org.drools.core.spi.Constraint)constraint);
        queryImpl.getLhs().addChild((RuleConditionElement)pattern);
        Variable[] args = query.getArguments();
        org.drools.core.rule.Declaration[] declarations = new org.drools.core.rule.Declaration[args.length];
        for (int i = 0; i < args.length; ++i) {
            int index = i;
            LambdaReadAccessor accessor = new LambdaReadAccessor(index, args[index].getType().asClass(), (Function1 & Serializable)obj -> ((DroolsQuery)obj).getElements()[index]);
            declarations[i] = new org.drools.core.rule.Declaration(args[i].getName(), (InternalReadAccessor)accessor, pattern, true);
            pattern.addDeclaration(declarations[i]);
            ctx.addQueryDeclaration(args[i], declarations[i]);
        }
        queryImpl.setParameters(declarations);
    }

    private void processConsequences(RuleContext ctx, Rule rule) {
        for (Map.Entry entry : rule.getConsequences().entrySet()) {
            this.processConsequence(ctx, (Consequence)entry.getValue(), (String)entry.getKey());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processConsequence(RuleContext ctx, Consequence consequence, String name) {
        if (name.equals("default")) {
            if ("java".equals(consequence.getLanguage())) {
                ctx.getRule().setConsequence((org.drools.core.spi.Consequence)new LambdaConsequence(consequence, ctx));
            } else {
                if (!"mvel".equals(consequence.getLanguage())) throw new UnsupportedOperationException("Unknown script language for consequence: " + consequence.getLanguage());
                ctx.getRule().setConsequence((org.drools.core.spi.Consequence)new MVELConsequence(consequence, ctx));
            }
        } else {
            ctx.getRule().addNamedConsequence(name, (org.drools.core.spi.Consequence)new LambdaConsequence(consequence, ctx));
        }
        Variable[] consequenceVars = consequence.getDeclarations();
        String[] requiredDeclarations = new String[consequenceVars.length];
        for (int i = 0; i < consequenceVars.length; ++i) {
            requiredDeclarations[i] = consequenceVars[i].getName();
        }
        ctx.getRule().setRequiredDeclarationsForConsequence(name, requiredDeclarations);
    }

    private void populateLHS(RuleContext ctx, KnowledgePackageImpl pkg, View view) {
        GroupElement lhs = ctx.getRule().getLhs();
        if (ctx.getRule().getRuleUnitClassName() != null) {
            lhs.addChild((RuleConditionElement)this.addPatternForVariable(ctx, lhs, this.getUnitVariable(ctx, pkg, view)));
        }
        this.addSubConditions(ctx, lhs, view.getSubConditions());
        if (this.requiresLeftActivation((RuleConditionElement)lhs)) {
            lhs.addChild(0, (RuleConditionElement)new org.drools.core.rule.Pattern(0, (ObjectType)ClassObjectType.InitialFact_ObjectType));
        }
    }

    private boolean requiresLeftActivation(RuleConditionElement rce) {
        if (rce instanceof GroupElement) {
            GroupElement and = (GroupElement)rce;
            return and.getChildren().isEmpty() || this.requiresLeftActivation((RuleConditionElement)and.getChildren().get(0));
        }
        return rce instanceof QueryElement;
    }

    private Variable getUnitVariable(RuleContext ctx, KnowledgePackageImpl pkg, View view) {
        String unitClassName = ctx.getRule().getRuleUnitClassName();
        for (Variable var : view.getBoundVariables()) {
            if (!(var instanceof DeclarationImpl) || !var.getType().asClass().getName().equals(unitClassName)) continue;
            return ((DeclarationImpl)var).setSource((DeclarationSource)DSL.entryPoint((String)"$$units$$"));
        }
        try {
            return DSL.declarationOf((Type)DSL.type((Class)pkg.getTypeResolver().resolveType(unitClassName)), (DeclarationSource)DSL.entryPoint((String)"$$units$$"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private RuleConditionElement conditionToElement(RuleContext ctx, GroupElement group, Condition condition) {
        if (condition.getType().isComposite()) {
            return this.addSubConditions(ctx, new GroupElement(ModelCompilerUtil.conditionToGroupElementType(condition.getType())), condition.getSubConditions());
        }
        switch (condition.getType()) {
            case PATTERN: {
                return this.buildPattern(ctx, group, condition);
            }
            case EVAL: {
                return this.buildEval(ctx, (EvalImpl)condition);
            }
            case ACCUMULATE: {
                org.drools.core.rule.Pattern source;
                AccumulatePattern accumulatePattern = (AccumulatePattern)condition;
                if (accumulatePattern.getCompositePatterns().isPresent()) {
                    CompositePatterns compositePatterns = (CompositePatterns)accumulatePattern.getCompositePatterns().get();
                    GroupElement ge = new GroupElement(ModelCompilerUtil.conditionToGroupElementType(compositePatterns.getType()));
                    for (Condition c : compositePatterns.getSubConditions()) {
                        ge.addChild((RuleConditionElement)this.buildPattern(ctx, group, c));
                    }
                    source = ge;
                } else {
                    source = this.buildPattern(ctx, group, condition);
                }
                org.drools.core.rule.Pattern pattern = null;
                if (accumulatePattern.getAccumulateFunctions().length == 1) {
                    pattern = ctx.getPattern(accumulatePattern.getAccumulateFunctions()[0].getVariable());
                }
                if (pattern == null) {
                    pattern = new org.drools.core.rule.Pattern(0, (ObjectType)this.getObjectType(Object.class));
                }
                PatternImpl sourcePattern = (PatternImpl)accumulatePattern.getPattern();
                ArrayList<String> usedVariableName = new ArrayList<String>();
                Binding binding = null;
                if (sourcePattern != null) {
                    for (Variable v : sourcePattern.getAllInputVariables()) {
                        usedVariableName.add(v.getName());
                    }
                    if (!sourcePattern.getBindings().isEmpty()) {
                        binding = (Binding)sourcePattern.getBindings().iterator().next();
                    }
                }
                pattern.setSource((PatternSource)this.buildAccumulate(ctx, accumulatePattern, (RuleConditionElement)source, pattern, usedVariableName, binding));
                return pattern;
            }
            case QUERY: {
                return this.buildQueryPattern(ctx, (QueryCallPattern)condition);
            }
            case NOT: 
            case EXISTS: {
                GroupElement ge = new GroupElement(ModelCompilerUtil.conditionToGroupElementType(condition.getType()));
                ge.addChild(this.conditionToElement(ctx, group, (Condition)condition.getSubConditions().get(0)));
                return ge;
            }
            case FORALL: {
                Condition innerCondition = (Condition)condition.getSubConditions().get(0);
                org.drools.core.rule.Pattern basePattern = (org.drools.core.rule.Pattern)this.conditionToElement(ctx, group, (Condition)innerCondition.getSubConditions().get(0));
                ArrayList<org.drools.core.rule.Pattern> remainingPatterns = new ArrayList<org.drools.core.rule.Pattern>();
                for (int i = 1; i < innerCondition.getSubConditions().size(); ++i) {
                    remainingPatterns.add((org.drools.core.rule.Pattern)this.conditionToElement(ctx, group, (Condition)innerCondition.getSubConditions().get(i)));
                }
                return new Forall(basePattern, remainingPatterns);
            }
            case CONSEQUENCE: {
                if (condition instanceof NamedConsequenceImpl) {
                    NamedConsequenceImpl consequence = (NamedConsequenceImpl)condition;
                    return consequence.getName().equals("default") ? null : new NamedConsequence(consequence.getName(), consequence.isBreaking());
                }
                if (!(condition instanceof ConditionalNamedConsequenceImpl)) break;
                return this.buildConditionalConsequence(ctx, (ConditionalNamedConsequenceImpl)condition);
            }
        }
        throw new UnsupportedOperationException();
    }

    private EvalCondition buildEval(RuleContext ctx, EvalImpl eval) {
        org.drools.core.rule.Declaration[] declarations = (org.drools.core.rule.Declaration[])Stream.of(eval.getExpr().getVariables()).map(ctx::getDeclaration).toArray(org.drools.core.rule.Declaration[]::new);
        LambdaEvalExpression evalExpr = new LambdaEvalExpression(declarations, eval.getExpr());
        return new EvalCondition((EvalExpression)evalExpr, declarations);
    }

    private ConditionalBranch buildConditionalConsequence(RuleContext ctx, ConditionalNamedConsequenceImpl consequence) {
        EvalCondition evalCondition;
        if (consequence.getExpr() != null) {
            org.drools.core.rule.Pattern pattern = ctx.getPattern(consequence.getExpr().getVariables()[0]);
            LambdaEvalExpression eval = new LambdaEvalExpression(pattern, consequence.getExpr());
            evalCondition = new EvalCondition((EvalExpression)eval, pattern.getRequiredDeclarations());
        } else {
            evalCondition = new EvalCondition(LambdaEvalExpression.EMPTY, null);
        }
        return new ConditionalBranch(evalCondition, new NamedConsequence(consequence.getThenConsequence().getName(), consequence.getThenConsequence().isBreaking()), consequence.getElseBranch() != null ? this.buildConditionalConsequence(ctx, consequence.getElseBranch()) : null);
    }

    private RuleConditionElement addSubConditions(RuleContext ctx, GroupElement ge, List<Condition> subconditions) {
        for (Condition subCondition : subconditions) {
            RuleConditionElement element = this.conditionToElement(ctx, ge, subCondition);
            if (element == null) continue;
            ge.addChild(element);
        }
        if (ge.getType() == GroupElement.AND && ge.getChildren().size() == 1) {
            return (RuleConditionElement)ge.getChildren().get(0);
        }
        return ge;
    }

    private RuleConditionElement buildQueryPattern(RuleContext ctx, QueryCallPattern queryPattern) {
        org.drools.core.rule.Pattern pattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), 0, (ObjectType)ClassObjectType.ObjectArray_ObjectType, null);
        SelfReferenceClassFieldReader arrayReader = new SelfReferenceClassFieldReader(Object[].class);
        QueryArgument[] arguments = new QueryArgument[queryPattern.getArguments().length];
        ArrayList<Integer> varIndexList = new ArrayList<Integer>();
        ArrayList<org.drools.core.rule.Declaration> requiredDeclarations = new ArrayList<org.drools.core.rule.Declaration>();
        for (int i2 = 0; i2 < queryPattern.getArguments().length; ++i2) {
            Argument arg = queryPattern.getArguments()[i2];
            if (arg instanceof Variable) {
                Variable var = (Variable)arg;
                org.drools.core.rule.Declaration decl = ctx.getDeclaration(var);
                if (decl != null) {
                    requiredDeclarations.add(decl);
                    arguments[i2] = new QueryArgument.Declr(decl);
                    continue;
                }
                ArrayElementReader reader = new ArrayElementReader((InternalReadAccessor)arrayReader, i2, arg.getType().asClass());
                pattern.addDeclaration(var.getName()).setReadAccessor((InternalReadAccessor)reader);
                arguments[i2] = QueryArgument.VAR;
                varIndexList.add(i2);
                continue;
            }
            if (arg instanceof Value) {
                arguments[i2] = new QueryArgument.Literal(((Value)arg).getValue());
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return new QueryElement(pattern, queryPattern.getQuery().getName(), arguments, varIndexList.stream().mapToInt(i -> i).toArray(), requiredDeclarations.toArray(new org.drools.core.rule.Declaration[requiredDeclarations.size()]), queryPattern.isOpen(), false);
    }

    private org.drools.core.rule.Pattern buildPattern(RuleContext ctx, GroupElement group, Condition condition) {
        Pattern modelPattern = (Pattern)condition;
        org.drools.core.rule.Pattern pattern = this.addPatternForVariable(ctx, group, modelPattern.getPatternVariable());
        for (Binding binding : modelPattern.getBindings()) {
            org.drools.core.rule.Declaration declaration = new org.drools.core.rule.Declaration(binding.getBoundVariable().getName(), (InternalReadAccessor)new LambdaReadAccessor(binding.getBoundVariable().getType().asClass(), (Function1)new Function1.Impl(binding.getBindingFunction())), pattern, true);
            pattern.addDeclaration(declaration);
            if (binding.getReactOn() != null) {
                this.addFieldsToPatternWatchlist(pattern, binding.getReactOn());
            }
            ctx.addInnerDeclaration(binding.getBoundVariable(), declaration);
        }
        org.drools.core.rule.Declaration queryArgDecl = ctx.getQueryDeclaration(modelPattern.getPatternVariable());
        if (queryArgDecl != null) {
            pattern.addConstraint((org.drools.core.spi.Constraint)new UnificationConstraint(queryArgDecl));
        }
        this.addConstraintsToPattern(ctx, pattern, modelPattern, modelPattern.getConstraint());
        this.addFieldsToPatternWatchlist(pattern, modelPattern.getWatchedProps());
        return pattern;
    }

    private Accumulate buildAccumulate(RuleContext ctx, AccumulatePattern accPattern, RuleConditionElement source, org.drools.core.rule.Pattern pattern, List<String> usedVariableName, Binding binding) {
        org.drools.model.functions.accumulate.AccumulateFunction[] accFunctions = accPattern.getAccumulateFunctions();
        if (accFunctions.length == 1) {
            org.drools.core.rule.Declaration[] declarationArray;
            AccumulateFunction accFunction = this.createRuntimeAccumulateFunction(accFunctions[0]);
            Variable boundVar = accPattern.getBoundVariables()[0];
            org.drools.core.rule.Declaration declaration = new org.drools.core.rule.Declaration(boundVar.getName(), org.drools.core.rule.Pattern.getReadAcessor((ObjectType)this.getObjectType(Object.class)), pattern, true);
            pattern.addDeclaration(declaration);
            if (binding != null) {
                declarationArray = new org.drools.core.rule.Declaration[]{};
            } else {
                org.drools.core.rule.Declaration[] declarationArray2 = new org.drools.core.rule.Declaration[1];
                declarationArray = declarationArray2;
                declarationArray2[0] = ctx.getPattern(accFunctions[0].getSource()).getDeclaration();
            }
            org.drools.core.rule.Declaration[] bindingDeclaration = declarationArray;
            SingleAccumulate accumulate = new SingleAccumulate(source, bindingDeclaration, (Accumulator)LambdaAccumulator.createLambdaAccumulator(accFunction, usedVariableName, binding));
            ctx.addAccumulateSource(boundVar, accumulate);
            return accumulate;
        }
        SelfReferenceClassFieldReader reader = new SelfReferenceClassFieldReader(Object[].class);
        Accumulator[] accumulators = new Accumulator[accFunctions.length];
        for (int i = 0; i < accFunctions.length; ++i) {
            AccumulateFunction accFunction = this.createRuntimeAccumulateFunction(accFunctions[i]);
            Variable accVar = accPattern.getBoundVariables()[i];
            pattern.addDeclaration(new org.drools.core.rule.Declaration(accVar.getName(), (InternalReadAccessor)new ArrayElementReader((InternalReadAccessor)reader, i, accVar.getType().asClass()), pattern, true));
            accumulators[i] = LambdaAccumulator.createLambdaAccumulator(accFunction, usedVariableName, binding);
        }
        return new MultiAccumulate(source, new org.drools.core.rule.Declaration[0], accumulators);
    }

    private AccumulateFunction createRuntimeAccumulateFunction(org.drools.model.functions.accumulate.AccumulateFunction accFunction1) {
        AccumulateFunction accFunction;
        try {
            accFunction = (AccumulateFunction)accFunction1.getFunctionClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return accFunction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private org.drools.core.rule.Pattern addPatternForVariable(RuleContext ctx, GroupElement group, Variable patternVariable) {
        Class patternClass = patternVariable.getType().asClass();
        org.drools.core.rule.Pattern pattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), 0, (ObjectType)this.getObjectType(patternClass), patternVariable.getName(), true);
        if (patternVariable instanceof Declaration) {
            Declaration decl = (Declaration)patternVariable;
            if (decl.getSource() != null) {
                if (decl.getSource() instanceof EntryPoint) {
                    pattern.setSource((PatternSource)new EntryPointId(((EntryPoint)decl.getSource()).getName()));
                } else if (decl.getSource() instanceof WindowReference) {
                    WindowReference window = (WindowReference)decl.getSource();
                    if (!ctx.getPkg().getWindowDeclarations().containsKey(window.getName())) {
                        this.createWindowReference(ctx, window);
                    }
                    pattern.setSource((PatternSource)new org.drools.core.rule.WindowReference(window.getName()));
                } else if (decl.getSource() instanceof From) {
                    From from = (From)decl.getSource();
                    LambdaDataProvider provider = new LambdaDataProvider(ctx.getDeclaration(from.getVariable()), from.getProvider(), from.isReactive());
                    org.drools.core.rule.From fromSource = new org.drools.core.rule.From((DataProvider)provider);
                    fromSource.setResultPattern(pattern);
                    pattern.setSource((PatternSource)fromSource);
                } else {
                    if (!(decl.getSource() instanceof UnitData)) throw new UnsupportedOperationException("Unknown source: " + decl.getSource());
                    UnitData unitData = (UnitData)decl.getSource();
                    pattern.setSource((PatternSource)new EntryPointId(ctx.getRule().getRuleUnitClassName() + "." + unitData.getName()));
                }
            } else {
                SingleAccumulate accSource = ctx.getAccumulateSource(patternVariable);
                if (accSource != null) {
                    for (RuleConditionElement element : group.getChildren()) {
                        if (!(element instanceof org.drools.core.rule.Pattern) || ((org.drools.core.rule.Pattern)element).getSource() != accSource) continue;
                        group.getChildren().remove(element);
                        break;
                    }
                    pattern.setSource((PatternSource)accSource);
                }
            }
            if (decl.getWindow() != null) {
                pattern.addBehavior(this.createWindow((WindowDefinition)decl.getWindow()));
            }
        }
        ctx.registerPattern(patternVariable, pattern);
        return pattern;
    }

    private <T> void createWindowReference(RuleContext ctx, WindowReference<T> window) {
        WindowDeclaration windowDeclaration = new WindowDeclaration(window.getName(), ctx.getPkg().getName());
        Declaration variable = DSL.declarationOf((Type)DSL.type((Class)window.getPatternType()));
        org.drools.core.rule.Pattern windowPattern = new org.drools.core.rule.Pattern(0, (ObjectType)this.getObjectType(window.getPatternType()), variable.getName());
        windowDeclaration.setPattern(windowPattern);
        for (Predicate1 predicate : window.getPredicates()) {
            SingleConstraint1 singleConstraint = new SingleConstraint1(NamesGenerator.generateName((String)"expr"), (Variable)variable, predicate);
            ConstraintEvaluator constraintEvaluator = new ConstraintEvaluator(windowPattern, (SingleConstraint)singleConstraint);
            windowPattern.addConstraint((org.drools.core.spi.Constraint)new LambdaConstraint(constraintEvaluator));
        }
        windowPattern.addBehavior(this.createWindow((WindowDefinition)window));
        ctx.getPkg().addWindowDeclaration(windowDeclaration);
    }

    private Behavior createWindow(WindowDefinition window) {
        switch (window.getType()) {
            case LENGTH: {
                return new SlidingLengthWindow((int)window.getValue());
            }
            case TIME: {
                return new SlidingTimeWindow(window.getValue());
            }
        }
        throw new IllegalArgumentException("Unknown window type: " + window.getType());
    }

    private void addConstraintsToPattern(RuleContext ctx, org.drools.core.rule.Pattern pattern, Pattern modelPattern, Constraint constraint) {
        if (constraint.getType() == Constraint.Type.SINGLE) {
            boolean isEqual;
            SingleConstraint singleConstraint = (SingleConstraint)constraint;
            boolean bl = isEqual = singleConstraint.getIndex() != null && singleConstraint.getIndex().getConstraintType() == Index.ConstraintType.EQUAL;
            if (singleConstraint.getVariables().length > 0) {
                Variable[] vars = singleConstraint.getVariables();
                org.drools.core.rule.Declaration[] declarations = new org.drools.core.rule.Declaration[vars.length];
                org.drools.core.rule.Declaration unificationDeclaration = null;
                for (int i = 0; i < vars.length; ++i) {
                    declarations[i] = ctx.getDeclaration(vars[i]);
                    if (!isEqual || ((ClassObjectType)declarations[i].getPattern().getObjectType()).getClassType() != DroolsQuery.class) continue;
                    unificationDeclaration = declarations[i];
                }
                ConstraintEvaluator constraintEvaluator = singleConstraint.isTemporal() ? new TemporalConstraintEvaluator(declarations, pattern, singleConstraint) : new ConstraintEvaluator(declarations, pattern, singleConstraint);
                MutableTypeConstraint droolsConstraint = unificationDeclaration != null ? new UnificationConstraint(unificationDeclaration, constraintEvaluator) : new LambdaConstraint(constraintEvaluator);
                pattern.addConstraint((org.drools.core.spi.Constraint)droolsConstraint);
            }
        } else if (modelPattern.getConstraint().getType() == Constraint.Type.AND) {
            for (Constraint child : constraint.getChildren()) {
                this.addConstraintsToPattern(ctx, pattern, modelPattern, child);
            }
        }
    }

    private void addFieldsToPatternWatchlist(org.drools.core.rule.Pattern pattern, String ... fields) {
        if (fields != null && fields.length > 0) {
            HashSet<String> watchlist = pattern.getListenedProperties();
            if (watchlist == null) {
                watchlist = new HashSet<String>();
                pattern.setListenedProperties(watchlist);
            }
            watchlist.addAll(Arrays.asList(fields));
        }
    }

    Collection<KiePackage> getKiePackages() {
        return this.packages.values();
    }

    ClassObjectType getObjectType(Class<?> patternClass) {
        return this.objectTypeCache.computeIfAbsent(patternClass, c -> {
            boolean isEvent = false;
            if (!patternClass.getName().startsWith("java.")) {
                KnowledgePackageImpl pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(patternClass.getPackage().getName(), this::createKiePackage);
                TypeDeclaration typeDeclaration = pkg.getTypeDeclaration(patternClass);
                if (typeDeclaration == null) {
                    typeDeclaration = TypeDeclarationUtil.createTypeDeclaration((InternalKnowledgePackage)pkg, patternClass);
                    pkg.addTypeDeclaration(typeDeclaration);
                }
                isEvent = typeDeclaration.getRole() == Role.Type.EVENT;
            }
            return new ClassObjectType(c, isEvent);
        });
    }
}

