/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.CompilationUnit;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.body.BodyDeclaration;
import org.drools.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.drools.javaparser.ast.body.FieldDeclaration;
import org.drools.javaparser.ast.body.InitializerDeclaration;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.body.VariableDeclarator;
import org.drools.javaparser.ast.comments.Comment;
import org.drools.javaparser.ast.comments.JavadocComment;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.printer.PrettyPrinter;
import org.drools.model.Global;
import org.drools.model.Model;
import org.drools.model.WindowReference;
import org.drools.modelcompiler.builder.generator.DRLIdGenerator;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.QueryParameter;
import org.kie.api.runtime.rule.AccumulateFunction;

public class PackageModel {
    private final String name;
    private Set<String> imports = new HashSet<String>();
    private Map<String, Class<?>> globals = new HashMap();
    private Map<String, MethodDeclaration> ruleMethods = new LinkedHashMap<String, MethodDeclaration>();
    private Map<String, MethodDeclaration> queryMethods = new HashMap<String, MethodDeclaration>();
    private Map<String, QueryGenerator.QueryDefWithType> queryDefWithType = new HashMap<String, QueryGenerator.QueryDefWithType>();
    private Map<String, MethodCallExpr> windowReferences = new HashMap<String, MethodCallExpr>();
    private Map<String, List<QueryParameter>> queryVariables = new HashMap<String, List<QueryParameter>>();
    private List<MethodDeclaration> functions = new ArrayList<MethodDeclaration>();
    private List<ClassOrInterfaceDeclaration> generatedPOJOs = new ArrayList<ClassOrInterfaceDeclaration>();
    private List<Expression> typeMetaDataExpressions = new ArrayList<Expression>();
    private DRLIdGenerator exprIdGenerator;
    private KnowledgeBuilderConfigurationImpl configuration;
    private Map<String, AccumulateFunction> accumulateFunctions;
    static final Type WINDOW_REFERENCE_TYPE = JavaParser.parseType((String)WindowReference.class.getCanonicalName());

    public PackageModel(String name, KnowledgeBuilderConfigurationImpl configuration) {
        this.name = name;
        this.configuration = configuration;
        this.exprIdGenerator = new DRLIdGenerator();
    }

    public KnowledgeBuilderConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public DRLIdGenerator getExprIdGenerator() {
        return this.exprIdGenerator;
    }

    public void addImports(Collection<String> imports) {
        this.imports.addAll(imports);
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    public void addGlobals(Map<String, String> values) {
        Map<String, Class> transformed = values.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> {
            try {
                return Class.forName((String)e.getValue());
            }
            catch (ClassNotFoundException e1) {
                throw new UnsupportedOperationException("Class not found", e1);
            }
        }));
        this.globals.putAll(transformed);
    }

    public Map<String, Class<?>> getGlobals() {
        return this.globals;
    }

    public void addTypeMetaDataExpressions(Expression typeMetaDataExpression) {
        this.typeMetaDataExpressions.add(typeMetaDataExpression);
    }

    public void putRuleMethod(String methodName, MethodDeclaration ruleMethod) {
        this.ruleMethods.put(methodName, ruleMethod);
    }

    public void putQueryMethod(MethodDeclaration queryMethod) {
        this.queryMethods.put(queryMethod.getNameAsString(), queryMethod);
    }

    public MethodDeclaration getQueryMethod(String key) {
        return this.queryMethods.get(key);
    }

    public void putQueryVariable(String queryName, QueryParameter qp) {
        this.queryVariables.computeIfAbsent(queryName, k -> new ArrayList());
        this.queryVariables.get(queryName).add(qp);
    }

    public List<QueryParameter> queryVariables(String queryName) {
        return this.queryVariables.get(queryName);
    }

    public Map<String, QueryGenerator.QueryDefWithType> getQueryDefWithType() {
        return this.queryDefWithType;
    }

    public void addAllFunctions(List<MethodDeclaration> functions) {
        this.functions.addAll(functions);
    }

    public void addGeneratedPOJO(ClassOrInterfaceDeclaration pojo) {
        this.generatedPOJOs.add(pojo);
    }

    public List<ClassOrInterfaceDeclaration> getGeneratedPOJOsSource() {
        return this.generatedPOJOs;
    }

    public void addAllWindowReferences(String methodName, MethodCallExpr windowMethod) {
        this.windowReferences.put(methodName, windowMethod);
    }

    public Map<String, MethodCallExpr> getWindowReferences() {
        return this.windowReferences;
    }

    public List<MethodDeclaration> getFunctions() {
        return this.functions;
    }

    public Map<String, AccumulateFunction> getAccumulateFunctions() {
        return this.accumulateFunctions;
    }

    public String getRulesSource(PrettyPrinter prettyPrinter, String className, String modelName) {
        MethodCallExpr add;
        NameExpr rulesFieldName;
        FieldDeclaration field;
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(this.name);
        cu.addImport(JavaParser.parseImport((String)"import java.util.*;"));
        cu.addImport(JavaParser.parseImport((String)"import org.drools.model.*;"));
        cu.addImport(JavaParser.parseImport((String)"import static org.drools.model.DSL.*;"));
        cu.addImport(JavaParser.parseImport((String)"import org.drools.model.Index.ConstraintType;"));
        cu.addImport(JavaParser.parseImport((String)"import java.time.*;"));
        cu.addImport(JavaParser.parseImport((String)"import java.time.format.*;"));
        cu.addImport(JavaParser.parseImport((String)"import java.text.*;"));
        cu.addImport(JavaParser.parseImport((String)"import org.drools.core.util.*;"));
        for (String i : this.imports) {
            if (i.equals(this.name + ".*")) continue;
            cu.addImport(JavaParser.parseImport((String)("import " + i + ";")));
        }
        ClassOrInterfaceDeclaration rulesClass = cu.addClass(className);
        rulesClass.addImplementedType(Model.class);
        BodyDeclaration dateFormatter = JavaParser.parseBodyDeclaration((String)"private final static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DateUtils.getDateFormatMask());\n");
        rulesClass.addMember(dateFormatter);
        BodyDeclaration getNameMethod = JavaParser.parseBodyDeclaration((String)("    @Override\n        public String getName() {\n        return \"" + modelName + "\";\n    }\n"));
        rulesClass.addMember(getNameMethod);
        BodyDeclaration getRulesMethod = JavaParser.parseBodyDeclaration((String)"    @Override\n    public List<Rule> getRules() {\n        return rules;\n    }\n");
        rulesClass.addMember(getRulesMethod);
        StringBuilder sb = new StringBuilder("\n");
        sb.append("With the following expression ID:\n");
        sb.append(this.exprIdGenerator.toString());
        sb.append("\n");
        JavadocComment exprIdComment = new JavadocComment(sb.toString());
        getRulesMethod.setComment((Comment)exprIdComment);
        BodyDeclaration getGlobalsMethod = JavaParser.parseBodyDeclaration((String)"    @Override\n    public List<Global> getGlobals() {\n        return globals;\n    }\n");
        rulesClass.addMember(getGlobalsMethod);
        BodyDeclaration getQueriesMethod = JavaParser.parseBodyDeclaration((String)"    @Override\n    public List<Query> getQueries() {\n        return queries;\n    }\n");
        rulesClass.addMember(getQueriesMethod);
        BodyDeclaration getTypeMetaDataMethod = JavaParser.parseBodyDeclaration((String)"    @Override\n    public List<TypeMetaData> getTypeMetaDatas() {\n        return typeMetaDatas;\n    }\n");
        rulesClass.addMember(getTypeMetaDataMethod);
        BodyDeclaration rulesList = JavaParser.parseBodyDeclaration((String)"List<Rule> rules = new ArrayList<>();");
        rulesClass.addMember(rulesList);
        BodyDeclaration queriesList = JavaParser.parseBodyDeclaration((String)"List<Query> queries = new ArrayList<>();");
        rulesClass.addMember(queriesList);
        BodyDeclaration globalsList = JavaParser.parseBodyDeclaration((String)"List<Global> globals = new ArrayList<>();");
        rulesClass.addMember(globalsList);
        BodyDeclaration windowReferencesList = JavaParser.parseBodyDeclaration((String)"List<WindowReference> windowReferences = new ArrayList<>();");
        rulesClass.addMember(windowReferencesList);
        BodyDeclaration typeMetaDatasList = JavaParser.parseBodyDeclaration((String)"List<TypeMetaData> typeMetaDatas = new ArrayList<>();");
        rulesClass.addMember(typeMetaDatasList);
        for (Map.Entry<String, MethodCallExpr> entry : this.windowReferences.entrySet()) {
            FieldDeclaration f = rulesClass.addField(WINDOW_REFERENCE_TYPE, entry.getKey(), new Modifier[0]);
            ((VariableDeclarator)f.getVariables().get(0)).setInitializer((Expression)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.getGlobals().entrySet()) {
            PackageModel.addGlobalField(rulesClass, this.getName(), entry.getKey(), (Class)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.queryDefWithType.entrySet()) {
            field = rulesClass.addField((Type)((QueryGenerator.QueryDefWithType)entry.getValue()).getQueryType(), entry.getKey(), new Modifier[]{Modifier.FINAL});
            ((VariableDeclarator)field.getVariables().get(0)).setInitializer((Expression)((QueryGenerator.QueryDefWithType)entry.getValue()).getMethodCallExpr());
        }
        for (Map.Entry<String, Object> entry : this.queryMethods.entrySet()) {
            field = rulesClass.addField(((MethodDeclaration)entry.getValue()).getType(), entry.getKey(), new Modifier[]{Modifier.FINAL});
            ((VariableDeclarator)field.getVariables().get(0)).setInitializer((Expression)new MethodCallExpr(null, entry.getKey()));
        }
        InitializerDeclaration rulesListInitializer = new InitializerDeclaration();
        rulesClass.addMember((BodyDeclaration)rulesListInitializer);
        BlockStmt blockStmt = new BlockStmt();
        rulesListInitializer.setBody(blockStmt);
        for (String string : this.ruleMethods.keySet()) {
            rulesFieldName = new NameExpr("rules");
            add = new MethodCallExpr((Expression)rulesFieldName, "add");
            add.addArgument((Expression)new MethodCallExpr(null, string));
            blockStmt.addStatement((Expression)add);
        }
        for (String string : this.queryMethods.keySet()) {
            rulesFieldName = new NameExpr("queries");
            add = new MethodCallExpr((Expression)rulesFieldName, "add");
            add.addArgument((Expression)new NameExpr(string));
            blockStmt.addStatement((Expression)add);
        }
        for (String string : this.windowReferences.keySet()) {
            rulesFieldName = new NameExpr("windowReferences");
            add = new MethodCallExpr((Expression)rulesFieldName, "add");
            add.addArgument((Expression)new NameExpr(string));
            blockStmt.addStatement((Expression)add);
        }
        for (Map.Entry entry : this.getGlobals().entrySet()) {
            rulesFieldName = new NameExpr("globals");
            add = new MethodCallExpr((Expression)rulesFieldName, "add");
            add.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar((String)entry.getKey())));
            blockStmt.addStatement((Expression)add);
        }
        for (Expression expression : this.typeMetaDataExpressions) {
            rulesFieldName = new NameExpr("typeMetaDatas");
            add = new MethodCallExpr((Expression)rulesFieldName, "add");
            add.addArgument(expression);
            blockStmt.addStatement((Expression)add);
        }
        this.functions.forEach(arg_0 -> ((ClassOrInterfaceDeclaration)rulesClass).addMember(arg_0));
        this.ruleMethods.values().forEach(arg_0 -> ((ClassOrInterfaceDeclaration)rulesClass).addMember(arg_0));
        this.queryMethods.values().forEach(arg_0 -> ((ClassOrInterfaceDeclaration)rulesClass).addMember(arg_0));
        return prettyPrinter.print((Node)cu);
    }

    private static void addGlobalField(ClassOrInterfaceDeclaration classDeclaration, String packageName, String globalName, Class<?> globalClass) {
        ClassOrInterfaceType varType = JavaParser.parseClassOrInterfaceType((String)Global.class.getCanonicalName());
        varType.setTypeArguments(new Type[]{DrlxParseUtil.classToReferenceType(globalClass)});
        Type declType = DrlxParseUtil.classToReferenceType(globalClass);
        MethodCallExpr declarationOfCall = new MethodCallExpr(null, "globalOf");
        MethodCallExpr typeCall = new MethodCallExpr(null, "type");
        typeCall.addArgument((Expression)new ClassExpr(declType));
        declarationOfCall.addArgument((Expression)typeCall);
        declarationOfCall.addArgument((Expression)new StringLiteralExpr(packageName));
        declarationOfCall.addArgument((Expression)new StringLiteralExpr(globalName));
        FieldDeclaration field = classDeclaration.addField((Type)varType, DrlxParseUtil.toVar(globalName), new Modifier[]{Modifier.FINAL});
        ((VariableDeclarator)field.getVariables().get(0)).setInitializer((Expression)declarationOfCall);
    }

    public void print(String source) {
        System.out.println("=====");
        System.out.println(source);
        System.out.println("=====");
    }

    public void addAccumulateFunctions(Map<String, AccumulateFunction> accumulateFunctions) {
        this.accumulateFunctions = accumulateFunctions;
    }

    public boolean hasDeclaration(String id) {
        return this.globals.get(id) != null;
    }
}

