/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.DescrVisitor;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.rule.builder.util.AccumulateUtil;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.body.Parameter;
import org.drools.javaparser.ast.expr.BinaryExpr;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.LambdaExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.stmt.ExpressionStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.ast.type.UnknownType;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.visitor.ModelGeneratorVisitor;
import org.kie.api.runtime.rule.AccumulateFunction;

public class AccumulateVisitor {
    private final RuleContext context;
    private final PackageModel packageModel;
    private final ModelGeneratorVisitor modelGeneratorVisitor;

    public AccumulateVisitor(ModelGeneratorVisitor modelGeneratorVisitor, RuleContext context, PackageModel packageModel) {
        this.modelGeneratorVisitor = modelGeneratorVisitor;
        this.context = context;
        this.packageModel = packageModel;
    }

    public void visit(AccumulateDescr descr, PatternDescr basePattern) {
        MethodCallExpr accumulateDSL = new MethodCallExpr(null, "accumulate");
        this.context.addExpression((Expression)accumulateDSL);
        MethodCallExpr accumulateExprs = new MethodCallExpr(null, "and");
        accumulateDSL.addArgument((Expression)accumulateExprs);
        this.context.pushExprPointer(arg_0 -> ((MethodCallExpr)accumulateExprs).addArgument(arg_0));
        BaseDescr input = descr.getInputPattern() == null ? descr.getInput() : descr.getInputPattern();
        boolean inputPatternHasConstraints = input instanceof PatternDescr && !((PatternDescr)input).getConstraint().getDescrs().isEmpty();
        input.accept((DescrVisitor)this.modelGeneratorVisitor);
        if (accumulateExprs.getArguments().isEmpty()) {
            accumulateDSL.remove((Node)accumulateExprs);
        } else if (accumulateExprs.getArguments().size() == 1) {
            accumulateDSL.setArgument(0, (Expression)accumulateExprs.getArguments().get(0));
        }
        for (AccumulateDescr.AccumulateFunctionCallDescr function : descr.getFunctions()) {
            this.visit(this.context, function, accumulateDSL, basePattern, inputPatternHasConstraints);
        }
        List bindExprs = accumulateDSL.getChildNodes().stream().filter(a -> a.toString().startsWith("bind")).collect(Collectors.toList());
        for (Node bindExpr : bindExprs) {
            accumulateDSL.remove(bindExpr);
        }
        this.context.popExprPointer();
        for (Node bindExpr : bindExprs) {
            this.context.getExpressions().add(0, (Expression)((MethodCallExpr)bindExpr));
        }
    }

    private void visit(RuleContext context, AccumulateDescr.AccumulateFunctionCallDescr function, MethodCallExpr accumulateDSL, PatternDescr basePattern, boolean inputPatternHasConstraints) {
        context.pushExprPointer(arg_0 -> ((MethodCallExpr)accumulateDSL).addArgument(arg_0));
        MethodCallExpr functionDSL = new MethodCallExpr(null, "accFunction");
        String expression = function.getParams()[0];
        Expression expr = DrlxParseUtil.parseExpression(expression).getExpr();
        String bindingId = Optional.ofNullable(function.getBind()).orElse(basePattern.getIdentifier());
        if (expr instanceof BinaryExpr) {
            DrlxParseResult drlxParseResult = ModelGenerator.drlxParse(context, this.packageModel, Object.class, bindingId, expression);
            AccumulateFunction accumulateFunction = this.getAccumulateFunction(function, drlxParseResult.getExprType());
            String bindExpressionVariable = context.getExprId(accumulateFunction.getResultType(), drlxParseResult.getLeft().toString());
            drlxParseResult.setExprBinding(bindExpressionVariable);
            context.addDeclaration(new DeclarationSpec(drlxParseResult.getPatternBinding(), drlxParseResult.getExprType()));
            functionDSL.addArgument((Expression)new ClassExpr(DrlxParseUtil.toType(accumulateFunction.getClass())));
            context.addExpression((Expression)this.buildBinding(bindExpressionVariable, drlxParseResult.getUsedDeclarations(), drlxParseResult.getExpr()));
            context.addDeclaration(new DeclarationSpec(bindExpressionVariable, drlxParseResult.getExprType()));
            functionDSL.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(bindExpressionVariable)));
        } else if (expr instanceof MethodCallExpr) {
            DrlxParseUtil.RemoveRootNodeResult methodCallWithoutRootNode = DrlxParseUtil.removeRootNode(expr);
            String rootNodeName = this.getRootNodeName(methodCallWithoutRootNode);
            TypedExpression typedExpression = this.parseMethodCallType(context, rootNodeName, methodCallWithoutRootNode.getWithoutRootNode());
            Class<?> methodCallExprType = typedExpression.getType();
            AccumulateFunction accumulateFunction = this.getAccumulateFunction(function, methodCallExprType);
            Class accumulateFunctionResultType = accumulateFunction.getResultType();
            functionDSL.addArgument((Expression)new ClassExpr(DrlxParseUtil.toType(accumulateFunction.getClass())));
            String bindExpressionVariable = context.getExprId(accumulateFunctionResultType, typedExpression.toString());
            Expression withThis = DrlxParseUtil.prepend((Expression)DrlxParseUtil._THIS_EXPR, typedExpression.getExpression());
            DrlxParseResult result = new DrlxParseResult(accumulateFunctionResultType, "", rootNodeName, withThis, accumulateFunctionResultType).setLeft(typedExpression).setExprBinding(bindExpressionVariable);
            context.addExpression((Expression)ModelGenerator.buildBinding(result));
            context.addDeclaration(new DeclarationSpec(bindExpressionVariable, methodCallExprType));
            functionDSL.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(bindExpressionVariable)));
            context.addDeclaration(new DeclarationSpec(bindingId, accumulateFunctionResultType));
        } else if (expr instanceof NameExpr) {
            Class<?> declarationClass = context.getDeclarationById(expr.toString()).orElseThrow(RuntimeException::new).getDeclarationClass();
            String nameExpr = ((NameExpr)expr).getName().asString();
            if (!inputPatternHasConstraints) {
                MethodCallExpr exprCall = new MethodCallExpr(null, "expr");
                exprCall.addArgument(DrlxParseUtil.toVar(nameExpr));
                this.getExprsMethod(accumulateDSL).addArgument((Expression)exprCall);
            }
            AccumulateFunction accumulateFunction = this.getAccumulateFunction(function, declarationClass);
            functionDSL.addArgument((Expression)new ClassExpr(DrlxParseUtil.toType(accumulateFunction.getClass())));
            functionDSL.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(nameExpr)));
            Class accumulateFunctionResultType = accumulateFunction.getResultType();
            context.addDeclaration(new DeclarationSpec(bindingId, accumulateFunctionResultType));
        } else {
            throw new UnsupportedOperationException("Unsupported expression " + expr);
        }
        MethodCallExpr asDSL = new MethodCallExpr((Expression)functionDSL, "as");
        asDSL.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(bindingId)));
        accumulateDSL.addArgument((Expression)asDSL);
        context.popExprPointer();
    }

    private MethodCallExpr getExprsMethod(MethodCallExpr accumulateDSL) {
        Expression firstArg;
        if (!accumulateDSL.getArguments().isEmpty() && (firstArg = accumulateDSL.getArgument(0)) instanceof MethodCallExpr && ((MethodCallExpr)firstArg).getNameAsString().equals("and")) {
            return (MethodCallExpr)firstArg;
        }
        return accumulateDSL;
    }

    private AccumulateFunction getAccumulateFunction(AccumulateDescr.AccumulateFunctionCallDescr function, Class<?> methodCallExprType) {
        String accumulateFunctionName = AccumulateUtil.getFunctionName(() -> methodCallExprType, (String)function.getFunction());
        Optional<AccumulateFunction> bundledAccumulateFunction = Optional.ofNullable(this.packageModel.getConfiguration().getAccumulateFunction(accumulateFunctionName));
        Optional<AccumulateFunction> importedAccumulateFunction = Optional.ofNullable(this.packageModel.getAccumulateFunctions().get(accumulateFunctionName));
        return bundledAccumulateFunction.map(Optional::of).orElse(importedAccumulateFunction).orElseThrow(RuntimeException::new);
    }

    private String getRootNodeName(DrlxParseUtil.RemoveRootNodeResult methodCallWithoutRootNode) {
        Expression rootNode = methodCallWithoutRootNode.getRootNode().orElseThrow(UnsupportedOperationException::new);
        if (!(rootNode instanceof NameExpr)) {
            throw new RuntimeException("Root node of expression should be a declaration");
        }
        String rootNodeName = ((NameExpr)rootNode).getName().asString();
        return rootNodeName;
    }

    private TypedExpression parseMethodCallType(RuleContext context, String variableName, Expression methodCallWithoutRoot) {
        Class clazz = context.getDeclarationById(variableName).map(DeclarationSpec::getDeclarationClass).orElseThrow(RuntimeException::new);
        return DrlxParseUtil.toMethodCallWithClassCheck(context, methodCallWithoutRoot, clazz, context.getPkg().getTypeResolver());
    }

    private MethodCallExpr buildBinding(String bindingName, Collection<String> usedDeclaration, Expression expression) {
        MethodCallExpr bindDSL = new MethodCallExpr(null, "bind");
        bindDSL.addArgument(DrlxParseUtil.toVar(bindingName));
        MethodCallExpr bindAsDSL = new MethodCallExpr((Expression)bindDSL, "as");
        usedDeclaration.stream().map(d -> new NameExpr(DrlxParseUtil.toVar(d))).forEach(arg_0 -> ((MethodCallExpr)bindAsDSL).addArgument(arg_0));
        bindAsDSL.addArgument(this.buildConstraintExpression(expression, usedDeclaration));
        return bindAsDSL;
    }

    private Expression buildConstraintExpression(Expression expr, Collection<String> usedDeclarations) {
        LambdaExpr lambdaExpr = new LambdaExpr();
        lambdaExpr.setEnclosingParameters(true);
        usedDeclarations.stream().map(s -> new Parameter((Type)new UnknownType(), s)).forEach(arg_0 -> ((LambdaExpr)lambdaExpr).addParameter(arg_0));
        lambdaExpr.setBody((Statement)new ExpressionStmt(expr));
        return lambdaExpr;
    }
}

