/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.consequence;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Tuple;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.AllSetButLastBitMask;
import org.drools.core.util.bitmask.EmptyBitMask;
import org.drools.core.util.bitmask.OpenBitSet;
import org.drools.model.BitMask;
import org.drools.model.Consequence;
import org.drools.model.Drools;
import org.drools.model.DroolsEntryPoint;
import org.drools.model.Variable;
import org.drools.model.bitmask.EmptyButLastBitMask;
import org.drools.model.bitmask.LongBitMask;
import org.drools.modelcompiler.RuleContext;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

public class LambdaConsequence
implements org.drools.core.spi.Consequence {
    private final Consequence consequence;
    private final RuleContext context;

    public LambdaConsequence(Consequence consequence, RuleContext context) {
        this.consequence = consequence;
        this.context = context;
    }

    public String getName() {
        return "default";
    }

    public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
        Object[] facts;
        Tuple tuple = knowledgeHelper.getTuple();
        Declaration[] declarations = ((RuleTerminalNode)knowledgeHelper.getMatch().getTuple().getTupleSink()).getRequiredDeclarations();
        Variable[] vars = this.consequence.getVariables();
        int factsOffset = 0;
        if (this.consequence.isUsingDrools()) {
            ++factsOffset;
            facts = new Object[vars.length + 1];
            facts[0] = new DroolsImpl(knowledgeHelper, workingMemory);
        } else {
            facts = new Object[vars.length];
        }
        int declrCounter = 0;
        for (Variable var : vars) {
            if (var.isFact()) {
                Declaration declaration = declarations[declrCounter++];
                InternalFactHandle fh = tuple.get(declaration);
                if (this.consequence.isUsingDrools()) {
                    ((DroolsImpl)facts[0]).registerFactHandle(fh);
                }
                facts[factsOffset++] = declaration.getValue((InternalWorkingMemory)workingMemory, fh.getObject());
                continue;
            }
            facts[factsOffset++] = workingMemory.getGlobal(var.getName());
        }
        this.consequence.getBlock().execute(facts);
        Object[] objs = knowledgeHelper.getTuple().toObjects();
        for (Consequence.Update update : this.consequence.getUpdates()) {
            Object updatedFact = this.context.getBoundFact(update.getUpdatedVariable(), objs);
            knowledgeHelper.update(updatedFact);
        }
        for (Consequence.Update update : this.consequence.getInserts()) {
            Object insertedFact = update.apply(facts);
            knowledgeHelper.insert(insertedFact);
        }
        for (Consequence.Update update : this.consequence.getDeletes()) {
            Object deletedFact = this.context.getBoundFact((Variable)update, objs);
            knowledgeHelper.delete(deletedFact);
        }
    }

    private static org.drools.core.util.bitmask.BitMask adaptBitMask(BitMask mask) {
        if (mask instanceof LongBitMask) {
            return new org.drools.core.util.bitmask.LongBitMask(((LongBitMask)mask).asLong());
        }
        if (mask instanceof org.drools.model.bitmask.EmptyBitMask) {
            return EmptyBitMask.get();
        }
        if (mask instanceof org.drools.model.bitmask.AllSetBitMask) {
            return AllSetBitMask.get();
        }
        if (mask instanceof org.drools.model.bitmask.AllSetButLastBitMask) {
            return AllSetButLastBitMask.get();
        }
        if (mask instanceof EmptyButLastBitMask) {
            return org.drools.core.util.bitmask.EmptyButLastBitMask.get();
        }
        if (mask instanceof org.drools.model.bitmask.OpenBitSet) {
            return new OpenBitSet(((org.drools.model.bitmask.OpenBitSet)mask).getBits(), ((org.drools.model.bitmask.OpenBitSet)mask).getNumWords());
        }
        throw new IllegalArgumentException("Unknown bitmask: " + mask);
    }

    public static class DroolsEntryPointImpl
    implements DroolsEntryPoint {
        private final EntryPoint entryPoint;
        private final Map<Object, InternalFactHandle> fhLookup;

        public DroolsEntryPointImpl(EntryPoint entryPoint, Map<Object, InternalFactHandle> fhLookup) {
            this.entryPoint = entryPoint;
            this.fhLookup = fhLookup;
        }

        public void insert(Object object) {
            this.entryPoint.insert(object);
        }

        public void insert(Object object, boolean dynamic) {
            ((WorkingMemoryEntryPoint)this.entryPoint).insert(object, dynamic);
        }

        public void update(Object object, String ... modifiedProperties) {
            this.entryPoint.update((FactHandle)this.fhLookup.get(object), object, modifiedProperties);
        }

        public void update(Object object, BitMask modifiedProperties) {
            Class modifiedClass = modifiedProperties.getPatternClass();
            ((WorkingMemoryEntryPoint)this.entryPoint).update((FactHandle)this.fhLookup.get(object), object, LambdaConsequence.adaptBitMask(modifiedProperties), modifiedClass, null);
        }

        public void delete(Object object) {
            this.entryPoint.delete((FactHandle)this.fhLookup.get(object));
        }
    }

    public static class DroolsImpl
    implements Drools {
        private final KnowledgeHelper knowledgeHelper;
        private final WorkingMemory workingMemory;
        private final Map<Object, InternalFactHandle> fhLookup = new IdentityHashMap<Object, InternalFactHandle>();

        DroolsImpl(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            this.workingMemory = workingMemory;
            this.knowledgeHelper = knowledgeHelper;
        }

        public void insert(Object object) {
            this.workingMemory.insert(object);
        }

        public void insert(Object object, boolean dynamic) {
            this.workingMemory.insert(object, dynamic);
        }

        public void insertLogical(Object object) {
            this.knowledgeHelper.insertLogical(object);
        }

        public void update(Object object, String ... modifiedProperties) {
            Class<?> modifiedClass = object.getClass();
            TypeDeclaration typeDeclaration = this.workingMemory.getKnowledgeBase().getOrCreateExactTypeDeclaration(modifiedClass);
            AllSetBitMask mask = typeDeclaration.isPropertyReactive() ? PropertySpecificUtil.calculatePositiveMask(modifiedClass, Arrays.asList(modifiedProperties), (List)typeDeclaration.getAccessibleProperties()) : AllSetBitMask.get();
            this.knowledgeHelper.update((FactHandle)this.fhLookup.get(object), (org.drools.core.util.bitmask.BitMask)mask, modifiedClass);
        }

        public void update(Object object, BitMask modifiedProperties) {
            Class modifiedClass = modifiedProperties.getPatternClass();
            this.knowledgeHelper.update((FactHandle)this.fhLookup.get(object), LambdaConsequence.adaptBitMask(modifiedProperties), modifiedClass);
        }

        public void delete(Object object) {
            this.workingMemory.delete((FactHandle)this.fhLookup.get(object));
        }

        void registerFactHandle(InternalFactHandle fh) {
            this.fhLookup.put(fh.getObject(), fh);
        }

        public <T> T getRuntime(Class<T> runtimeClass) {
            return (T)this.knowledgeHelper.getKieRuntime();
        }

        public DroolsEntryPoint getEntryPoint(String name) {
            return new DroolsEntryPointImpl(this.knowledgeHelper.getEntryPoint(name), this.fhLookup);
        }
    }
}

