/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards.parser.xls;

import java.util.List;
import org.dmg.pmml.pmml_4_2.descr.Attribute;
import org.dmg.pmml.pmml_4_2.descr.Characteristic;
import org.dmg.pmml.pmml_4_2.descr.Characteristics;
import org.dmg.pmml.pmml_4_2.descr.Scorecard;
import org.drools.core.util.StringUtils;
import org.drools.pmml.pmml_4_2.PMML4Helper;
import org.drools.pmml.pmml_4_2.extensions.AggregationStrategy;
import org.drools.scorecards.ScorecardError;
import org.drools.scorecards.StringUtil;
import org.drools.scorecards.pmml.ScorecardPMMLUtils;

class ExcelScorecardValidator {
    private Scorecard scorecard;
    private List<ScorecardError> parseErrors;

    private ExcelScorecardValidator(Scorecard scorecard, List<ScorecardError> parseErrors) {
        this.scorecard = scorecard;
        this.parseErrors = parseErrors;
    }

    public static void runAdditionalValidations(Scorecard scorecard, List<ScorecardError> parseErrors) {
        ExcelScorecardValidator validator = new ExcelScorecardValidator(scorecard, parseErrors);
        validator.checkForInvalidDataTypes();
        validator.checkForMissingAttributes();
        if (scorecard.getUseReasonCodes().booleanValue()) {
            validator.validateReasonCodes();
            validator.validateBaselineScores();
        }
        if (ExcelScorecardValidator.getScoringStrategy(scorecard).toString().startsWith("WEIGHTED")) {
            validator.validateWeights();
        }
    }

    private void validateWeights() {
        for (Object obj : this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Characteristics)) continue;
            Characteristics characteristics = (Characteristics)obj;
            for (Characteristic characteristic : characteristics.getCharacteristics()) {
                for (Attribute attribute : characteristic.getAttributes()) {
                    String newCellRef = this.createDataTypeCellRef(ScorecardPMMLUtils.getExtensionValue(attribute.getExtensions(), "cellRef"), 2);
                    String weight = ScorecardPMMLUtils.getExtensionValue(attribute.getExtensions(), "weight");
                    if (!StringUtils.isEmpty((CharSequence)weight) && this.isDouble(weight)) continue;
                    this.parseErrors.add(new ScorecardError(newCellRef, "Attribute is missing weight or specified weight is not a double."));
                }
            }
        }
    }

    protected boolean isDouble(String doubleStr) {
        try {
            Double.parseDouble(doubleStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void validateReasonCodes() {
        for (Object obj : this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Characteristics)) continue;
            Characteristics characteristics = (Characteristics)obj;
            for (Characteristic characteristic : characteristics.getCharacteristics()) {
                String charReasonCode = characteristic.getReasonCode();
                if (charReasonCode != null && !StringUtils.isEmpty((CharSequence)charReasonCode)) continue;
                for (Attribute attribute : characteristic.getAttributes()) {
                    String newCellRef = this.createDataTypeCellRef(ScorecardPMMLUtils.getExtensionValue(attribute.getExtensions(), "cellRef"), 3);
                    String attrReasonCode = attribute.getReasonCode();
                    if (attrReasonCode != null && !StringUtils.isEmpty((CharSequence)attrReasonCode)) continue;
                    this.parseErrors.add(new ScorecardError(newCellRef, "Attribute is missing Reason Code"));
                }
            }
        }
    }

    private void validateBaselineScores() {
        for (Object obj : this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            Double scorecardBaseline = this.scorecard.getBaselineScore();
            if (!(obj instanceof Characteristics)) continue;
            Characteristics characteristics = (Characteristics)obj;
            for (Characteristic characteristic : characteristics.getCharacteristics()) {
                Double charBaseline = characteristic.getBaselineScore();
                if (charBaseline != null && charBaseline != 0.0 || scorecardBaseline != null && scorecardBaseline != 0.0) continue;
                String newCellRef = this.createDataTypeCellRef(ScorecardPMMLUtils.getExtensionValue(characteristic.getExtensions(), "cellRef"), 2);
                this.parseErrors.add(new ScorecardError(newCellRef, "Characteristic is missing Baseline Score"));
            }
        }
    }

    private void checkForInvalidDataTypes() {
        for (Object obj : this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Characteristics)) continue;
            Characteristics characteristics = (Characteristics)obj;
            block1: for (Characteristic characteristic : characteristics.getCharacteristics()) {
                String value;
                String dataType = ScorecardPMMLUtils.getExtensionValue(characteristic.getExtensions(), "dataType");
                String newCellRef = this.createDataTypeCellRef(ScorecardPMMLUtils.getExtensionValue(characteristic.getExtensions(), "cellRef"), 1);
                if (dataType == null || StringUtils.isEmpty((CharSequence)dataType)) {
                    this.parseErrors.add(new ScorecardError(newCellRef, "Missing Data Type!"));
                } else if (!("Text".equalsIgnoreCase(dataType) || "Number".equalsIgnoreCase(dataType) || "Boolean".equalsIgnoreCase(dataType))) {
                    this.parseErrors.add(new ScorecardError(newCellRef, "Invalid Data Type!"));
                }
                if ("Boolean".equalsIgnoreCase(dataType)) {
                    for (Attribute attribute : characteristic.getAttributes()) {
                        value = ScorecardPMMLUtils.getExtensionValue(attribute.getExtensions(), "predicateResolver");
                        if ("TRUE".equalsIgnoreCase(value) || "FALSE".equalsIgnoreCase(value)) continue;
                        this.parseErrors.add(new ScorecardError(newCellRef, "Characteristic '" + characteristic.getName() + "' is Boolean and can support TRUE|FALSE only"));
                        continue block1;
                    }
                    continue;
                }
                if (!"Number".equalsIgnoreCase(dataType)) continue;
                for (Attribute attribute : characteristic.getAttributes()) {
                    value = ScorecardPMMLUtils.getExtensionValue(attribute.getExtensions(), "predicateResolver");
                    if (StringUtil.isNumericWithOperators(value)) continue;
                    this.parseErrors.add(new ScorecardError(newCellRef, "Characteristic '" + characteristic.getName() + "' is Number and can support numerics only"));
                }
            }
        }
    }

    private void checkForMissingAttributes() {
        for (Object obj : this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Characteristics)) continue;
            Characteristics characteristics = (Characteristics)obj;
            for (Characteristic characteristic : characteristics.getCharacteristics()) {
                String newCellRef = ScorecardPMMLUtils.getExtensionValue(characteristic.getExtensions(), "cellRef");
                if (characteristic.getAttributes().size() != 0) continue;
                this.parseErrors.add(new ScorecardError(newCellRef, "Missing Attribute Bins for Characteristic '" + characteristic.getName() + "'."));
            }
        }
    }

    private String createDataTypeCellRef(String cellRef, int n) {
        int col = cellRef.charAt(1) + n;
        return "$" + (char)col + cellRef.substring(cellRef.indexOf(36, 1));
    }

    protected static AggregationStrategy getScoringStrategy(Scorecard scorecard) {
        String scoringStrategyName = ScorecardPMMLUtils.getExtensionValue(scorecard.getExtensionsAndCharacteristicsAndMiningSchemas(), "scoringStrategy");
        return PMML4Helper.resolveAggregationStrategy((String)scoringStrategyName);
    }
}

