/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

class InternalPushConnection<C>
extends BasePackPushConnection {
    private Thread worker;

    public InternalPushConnection(PackTransport transport, final ReceivePackFactory<C> receivePackFactory, final C req, final Repository remote) throws TransportException {
        super(transport);
        PipedOutputStream out_w;
        PipedInputStream out_r;
        PipedOutputStream in_w;
        PipedInputStream in_r;
        try {
            in_r = new PipedInputStream();
            in_w = new PipedOutputStream(in_r);
            out_r = new PipedInputStream();
            out_w = new PipedOutputStream(out_r);
        }
        catch (IOException err) {
            remote.close();
            throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
        }
        this.worker = new Thread("JGit-Receive-Pack"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ReceivePack rp = receivePackFactory.create(req, remote);
                    rp.receive(out_r, in_w, System.err);
                }
                catch (ServiceNotEnabledException e) {
                }
                catch (ServiceNotAuthorizedException e) {
                }
                catch (IOException err) {
                }
                catch (RuntimeException err) {
                }
                finally {
                    try {
                        out_r.close();
                    }
                    catch (IOException e2) {}
                    try {
                        in_w.close();
                    }
                    catch (IOException e2) {}
                    remote.close();
                }
            }
        };
        this.worker.start();
        this.init(in_r, out_w);
        this.readAdvertisedRefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        if (this.worker != null) {
            try {
                this.worker.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.worker = null;
            }
        }
    }
}

