/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.helper;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

public class BuildUtil {
    private BuildUtil() {
    }

    public static String extractBaseFromConfiguration(@Nonnull BuildConfiguration buildConfig) {
        String fromImage = buildConfig.getFrom();
        if (fromImage == null && buildConfig.getAssembly() == null) {
            fromImage = "busybox:latest";
        }
        return fromImage;
    }

    public static String extractBaseFromDockerfile(@Nonnull JKubeConfiguration configuration, @Nonnull BuildConfiguration buildConfig) {
        String fromImage;
        try {
            File fullDockerFilePath = buildConfig.getAbsoluteDockerFilePath(configuration.getSourceDirectory(), (String)Optional.ofNullable(configuration.getProject()).map(JavaProject::getBaseDirectory).map(File::toString).orElse(null));
            fromImage = DockerFileUtil.extractBaseImages(fullDockerFilePath, configuration.getProperties(), buildConfig.getFilter(), buildConfig.getArgs()).stream().findFirst().orElse(null);
        }
        catch (IOException e) {
            fromImage = null;
        }
        return fromImage;
    }
}

