/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.common.util.Serialization;

public class KubernetesConfigAuthUtil {
    private static final String KUBECONFIG_ENV = "KUBECONFIG";
    private static final Path KUBECONFIG_FILE = Paths.get(".kube", "config");

    private KubernetesConfigAuthUtil() {
    }

    public static AuthConfig readKubeConfigAuth() {
        Map<String, Object> kubeConfig = KubernetesConfigAuthUtil.readKubeConfig();
        if (kubeConfig == null) {
            return null;
        }
        String currentContextName = (String)kubeConfig.get("current-context");
        if (currentContextName == null) {
            return null;
        }
        for (Map contextMap : (List)kubeConfig.get("contexts")) {
            if (!currentContextName.equals(contextMap.get("name"))) continue;
            return KubernetesConfigAuthUtil.parseContext(kubeConfig, (Map)contextMap.get("context"));
        }
        return null;
    }

    private static AuthConfig parseContext(Map<String, ?> kubeConfig, Map<String, ?> context) {
        if (context == null) {
            return null;
        }
        String userName = (String)context.get("user");
        if (userName == null) {
            return null;
        }
        List users = (List)kubeConfig.get("users");
        if (users == null) {
            return null;
        }
        for (Map userMap : users) {
            if (!userName.equals(userMap.get("name"))) continue;
            return KubernetesConfigAuthUtil.parseUser(userName, (Map)userMap.get("user"));
        }
        return null;
    }

    private static AuthConfig parseUser(String userName, Map<String, ?> user) {
        if (user == null) {
            return null;
        }
        String token = (String)user.get("token");
        if (token == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("^([^/]+).*$").matcher(userName);
        return AuthConfig.builder().username(matcher.matches() ? matcher.group(1) : userName).password(token).build();
    }

    private static Map<String, Object> readKubeConfig() {
        File applicableFile;
        String kubeConfig = System.getenv(KUBECONFIG_ENV);
        File file = applicableFile = kubeConfig == null ? KubernetesConfigAuthUtil.getHomeDir().toPath().resolve(KUBECONFIG_FILE).toFile() : new File(kubeConfig);
        if (applicableFile.exists()) {
            try {
                return (Map)Serialization.unmarshal((File)applicableFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyMap();
    }

    private static File getHomeDir() {
        String homeDir = System.getProperty("user.home") != null ? System.getProperty("user.home") : System.getenv("HOME");
        return new File(homeDir);
    }
}

