/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.config.handler.property;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jkube.kit.build.api.config.handler.property.ConfigKey;
import org.eclipse.jkube.kit.build.api.config.handler.property.PropertyMode;
import org.eclipse.jkube.kit.build.api.config.handler.property.ValueProvider;
import org.eclipse.jkube.kit.build.api.helper.ExternalConfigHandler;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.MapUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.WatchImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.HealthCheckConfiguration;

public class PropertyConfigHandler
implements ExternalConfigHandler {
    public static final String TYPE_NAME = "properties";
    public static final String DEFAULT_PREFIX = "docker";

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    @Override
    public List<ImageConfiguration> resolve(ImageConfiguration fromConfig, JavaProject project) {
        Map externalConfig = fromConfig.getExternalConfig();
        String prefix = PropertyConfigHandler.getPrefix(externalConfig);
        Properties properties = JKubeProjectUtil.getPropertiesWithSystemOverrides((JavaProject)project);
        PropertyMode propertyMode = PropertyConfigHandler.getMode(externalConfig);
        ValueProvider valueProvider = new ValueProvider(prefix, properties, propertyMode);
        BuildConfiguration build = this.extractBuildConfiguration(fromConfig, valueProvider, project);
        WatchImageConfiguration watch = this.extractWatchConfig(fromConfig, valueProvider);
        String name = valueProvider.getString(ConfigKey.NAME, fromConfig.getName());
        String alias = valueProvider.getString(ConfigKey.ALIAS, fromConfig.getAlias());
        if (name == null) {
            throw new IllegalArgumentException(String.format("Mandatory property [%s] is not defined", new Object[]{ConfigKey.NAME}));
        }
        return Collections.singletonList(ImageConfiguration.builder().name(name).alias(alias).build(build).watch(watch).build());
    }

    private static boolean isStringValueNull(ValueProvider valueProvider, BuildConfiguration config, ConfigKey key, Supplier<String> supplier) {
        return valueProvider.getString(key, config == null ? null : supplier.get()) != null;
    }

    private boolean buildConfigured(BuildConfiguration config, ValueProvider valueProvider, JavaProject project) {
        if (PropertyConfigHandler.isStringValueNull(valueProvider, config, ConfigKey.FROM, () -> ((BuildConfiguration)config).getFrom())) {
            return true;
        }
        if (valueProvider.getMap(ConfigKey.FROM_EXT, config == null ? null : config.getFromExt()) != null) {
            return true;
        }
        if (PropertyConfigHandler.isStringValueNull(valueProvider, config, ConfigKey.DOCKER_FILE, () -> ((BuildConfiguration)config).getDockerFileRaw())) {
            return true;
        }
        if (PropertyConfigHandler.isStringValueNull(valueProvider, config, ConfigKey.DOCKER_ARCHIVE, () -> ((BuildConfiguration)config).getDockerArchiveRaw())) {
            return true;
        }
        if (PropertyConfigHandler.isStringValueNull(valueProvider, config, ConfigKey.CONTEXT_DIR, () -> ((BuildConfiguration)config).getContextDirRaw())) {
            return true;
        }
        return new File(project.getBaseDirectory(), "Dockerfile").exists();
    }

    private static <T, R> R valueOrNull(T input, Function<T, R> function) {
        return Optional.ofNullable(input).map(function).orElse(null);
    }

    private BuildConfiguration extractBuildConfiguration(ImageConfiguration fromConfig, ValueProvider valueProvider, JavaProject project) {
        BuildConfiguration config = fromConfig.getBuildConfiguration();
        if (!this.buildConfigured(config, valueProvider, project)) {
            return null;
        }
        return BuildConfiguration.builder().cmd(this.extractArguments(valueProvider, ConfigKey.CMD, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getCmd))).cleanup(valueProvider.getString(ConfigKey.CLEANUP, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getCleanup))).nocache(valueProvider.getBoolean(ConfigKey.NOCACHE, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getNocache))).cacheFrom(this.extractCacheFrom(valueProvider.getString(ConfigKey.CACHEFROM, config == null ? null : (config.getCacheFrom() == null ? null : config.getCacheFrom().toString())), new String[0])).optimise(valueProvider.getBoolean(ConfigKey.OPTIMISE, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getOptimise))).entryPoint(this.extractArguments(valueProvider, ConfigKey.ENTRYPOINT, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getEntryPoint))).assembly(this.extractAssembly(PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getAssembly), valueProvider)).env(MapUtil.mergeMaps((Map[])new Map[]{valueProvider.getMap(ConfigKey.ENV_BUILD, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getEnv)), valueProvider.getMap(ConfigKey.ENV, Collections.emptyMap())})).args(valueProvider.getMap(ConfigKey.ARGS, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getArgs))).labels(valueProvider.getMap(ConfigKey.LABELS, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getLabels))).ports(this.extractPortValues(PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getPorts), valueProvider)).shell(this.extractArguments(valueProvider, ConfigKey.SHELL, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getShell))).runCmds(valueProvider.getList(ConfigKey.RUN, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getRunCmds))).from(valueProvider.getString(ConfigKey.FROM, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getFrom))).fromExt(valueProvider.getMap(ConfigKey.FROM_EXT, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getFromExt))).volumes(valueProvider.getList(ConfigKey.VOLUMES, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getVolumes))).tags(valueProvider.getList(ConfigKey.TAGS, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getTags))).maintainer(valueProvider.getString(ConfigKey.MAINTAINER, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getMaintainer))).workdir(valueProvider.getString(ConfigKey.WORKDIR, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getWorkdir))).skip(valueProvider.getBoolean(ConfigKey.SKIP_BUILD, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getSkip))).imagePullPolicy(valueProvider.getString(ConfigKey.IMAGE_PULL_POLICY_BUILD, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getImagePullPolicy))).contextDir(valueProvider.getString(ConfigKey.CONTEXT_DIR, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getContextDirRaw))).dockerArchive(valueProvider.getString(ConfigKey.DOCKER_ARCHIVE, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getDockerArchiveRaw))).dockerFile(valueProvider.getString(ConfigKey.DOCKER_FILE, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getDockerFileRaw))).buildOptions(valueProvider.getMap(ConfigKey.BUILD_OPTIONS, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getBuildOptions))).filter(valueProvider.getString(ConfigKey.FILTER, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getFilter))).user(valueProvider.getString(ConfigKey.USER, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getUser))).healthCheck(this.extractHealthCheck(PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getHealthCheck), valueProvider)).build();
    }

    List<String> extractCacheFrom(String cacheFrom, String ... more) {
        if (more == null || more.length == 0) {
            return Collections.singletonList(cacheFrom);
        }
        return Stream.concat(Stream.of(cacheFrom), Arrays.stream(more)).collect(Collectors.toList());
    }

    private AssemblyConfiguration extractAssembly(AssemblyConfiguration config, ValueProvider valueProvider) {
        return AssemblyConfiguration.builder().targetDir(valueProvider.getString(ConfigKey.ASSEMBLY_BASEDIR, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getTargetDir))).exportTargetDir(valueProvider.getBoolean(ConfigKey.ASSEMBLY_EXPORT_TARGET_DIR, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getExportTargetDir))).permissionsString(valueProvider.getString(ConfigKey.ASSEMBLY_PERMISSIONS, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getPermissionsRaw))).user(valueProvider.getString(ConfigKey.ASSEMBLY_USER, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getUser))).modeString(valueProvider.getString(ConfigKey.ASSEMBLY_MODE, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getModeRaw))).tarLongFileMode(valueProvider.getString(ConfigKey.ASSEMBLY_TARLONGFILEMODE, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getTarLongFileMode))).build();
    }

    private HealthCheckConfiguration extractHealthCheck(HealthCheckConfiguration config, ValueProvider valueProvider) {
        Map<String, String> healthCheckProperties = valueProvider.getMap(ConfigKey.HEALTHCHECK, Collections.emptyMap());
        if (healthCheckProperties != null && healthCheckProperties.size() > 0) {
            return HealthCheckConfiguration.builder().interval(valueProvider.getString(ConfigKey.HEALTHCHECK_INTERVAL, PropertyConfigHandler.valueOrNull(config, HealthCheckConfiguration::getInterval))).timeout(valueProvider.getString(ConfigKey.HEALTHCHECK_TIMEOUT, PropertyConfigHandler.valueOrNull(config, HealthCheckConfiguration::getTimeout))).startPeriod(valueProvider.getString(ConfigKey.HEALTHCHECK_START_PERIOD, PropertyConfigHandler.valueOrNull(config, HealthCheckConfiguration::getStartPeriod))).retries(valueProvider.getInteger(ConfigKey.HEALTHCHECK_RETRIES, PropertyConfigHandler.valueOrNull(config, HealthCheckConfiguration::getRetries))).modeString(valueProvider.getString(ConfigKey.HEALTHCHECK_MODE, config == null || config.getMode() == null ? null : config.getMode().name())).cmd(this.extractArguments(valueProvider, ConfigKey.HEALTHCHECK_CMD, PropertyConfigHandler.valueOrNull(config, HealthCheckConfiguration::getCmd))).build();
        }
        return config;
    }

    private List<String> extractPortValues(List<String> config, ValueProvider valueProvider) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> ports = valueProvider.getList(ConfigKey.PORTS, config);
        if (ports == null) {
            return null;
        }
        List parsedPorts = EnvUtil.splitOnLastColon(ports);
        for (String[] port : parsedPorts) {
            ret.add(port[1]);
        }
        return ret;
    }

    private Arguments extractArguments(ValueProvider valueProvider, ConfigKey configKey, Arguments alternative) {
        return valueProvider.getObject(configKey, alternative, raw -> raw != null ? Arguments.builder().shell(raw).build() : null);
    }

    private WatchImageConfiguration extractWatchConfig(ImageConfiguration fromConfig, ValueProvider valueProvider) {
        WatchImageConfiguration config = fromConfig.getWatchConfiguration();
        return WatchImageConfiguration.builder().interval(valueProvider.getInteger(ConfigKey.WATCH_INTERVAL, config == null ? null : config.getIntervalRaw())).postGoal(valueProvider.getString(ConfigKey.WATCH_POSTGOAL, config == null ? null : config.getPostGoal())).postExec(valueProvider.getString(ConfigKey.WATCH_POSTEXEC, config == null ? null : config.getPostExec())).modeString(valueProvider.getString(ConfigKey.WATCH_POSTGOAL, config == null || config.getMode() == null ? null : config.getMode().name())).build();
    }

    private static String getPrefix(Map<String, String> externalConfig) {
        String prefix = externalConfig.get("prefix");
        if (prefix == null) {
            prefix = DEFAULT_PREFIX;
        }
        return prefix;
    }

    private static PropertyMode getMode(Map<String, String> externalConfig) {
        return PropertyMode.parse(externalConfig.get("mode"));
    }

    public static boolean canCoexistWithOtherPropertyConfiguredImages(Map<String, String> externalConfig) {
        if (externalConfig == null || externalConfig.isEmpty()) {
            return false;
        }
        if (!TYPE_NAME.equals(externalConfig.get("type"))) {
            return true;
        }
        return externalConfig.get("prefix") != null;
    }
}

