/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.client.http.HttpResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Fabric8HttpUtil {
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";

    private Fabric8HttpUtil() {
    }

    public static Map<String, String> extractAuthenticationChallengeIntoMap(HttpResponse<?> response) {
        HashMap<String, String> result = new HashMap<String, String>();
        String wwwAuthenticateHeader = response.header(WWW_AUTHENTICATE);
        if (StringUtils.isNotBlank((CharSequence)wwwAuthenticateHeader)) {
            String[] wwwAuthenticateHeaders;
            for (String challenge : wwwAuthenticateHeaders = wwwAuthenticateHeader.split(",")) {
                String[] challengeParts;
                if (!challenge.contains("=") || (challengeParts = challenge.split("=")).length != 2) continue;
                result.put(challengeParts[0], StringUtils.strip((String)challengeParts[1], (String)"\""));
            }
        }
        return result;
    }

    public static String toFormData(Map<String, String> formData) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> e : formData.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(URLEncoder.encode(e.getKey(), StandardCharsets.UTF_8.name()));
            result.append("=");
            result.append(URLEncoder.encode(e.getValue(), StandardCharsets.UTF_8.name()));
        }
        return result.toString();
    }
}

