/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Properties getPropertiesFromResource(URL resource) {
        Properties ret = new Properties();
        if (resource != null) {
            try (InputStream stream = resource.openStream();){
                ret.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading resource from URL " + resource, e);
            }
        }
        return ret;
    }

    public static String getValueFromProperties(Properties properties, String ... keys) {
        for (String property : keys) {
            String value;
            if (!properties.containsKey(property) || !Utils.isNotNullOrEmpty((String)(value = properties.get(property).toString()))) continue;
            return value;
        }
        return null;
    }

    public static Map<String, String> toMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : Optional.ofNullable(properties).map(Hashtable::entrySet).orElse(Collections.emptySet())) {
            map.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return map;
    }
}

