/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.api.model.DefaultKubernetesResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HasMetadataComparator;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.common.util.Serialization;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static List<HasMetadata> deserializeKubernetesListOrTemplate(File manifest) throws IOException {
        if (!manifest.isFile() || !manifest.exists()) {
            return Collections.emptyList();
        }
        ArrayList<HasMetadata> kubernetesResources = new ArrayList<HasMetadata>(ResourceUtil.split(Serialization.unmarshal(manifest)));
        kubernetesResources.sort((Comparator<HasMetadata>)new HasMetadataComparator());
        return kubernetesResources;
    }

    private static List<HasMetadata> split(Object resource) {
        if (resource instanceof Collection) {
            ArrayList<HasMetadata> collectionItems = new ArrayList<HasMetadata>();
            for (Object item : (Collection)resource) {
                collectionItems.addAll(ResourceUtil.split(item));
            }
            return collectionItems;
        }
        if (resource instanceof KubernetesList) {
            return ((KubernetesList)resource).getItems();
        }
        if (resource instanceof Template) {
            return Optional.ofNullable(OpenshiftHelper.processTemplatesLocally((Template)resource, false)).map(DefaultKubernetesResourceList::getItems).orElse(Collections.emptyList());
        }
        if (resource instanceof HasMetadata) {
            return Collections.singletonList((HasMetadata)resource);
        }
        return Collections.emptyList();
    }

    public static File save(File file, Object data) throws IOException {
        return ResourceUtil.save(file, data, ResourceFileType.fromFile(file));
    }

    public static File save(File file, Object data, ResourceFileType type) throws IOException {
        boolean hasExtension = FilenameUtils.indexOfExtension((String)file.getAbsolutePath()) != -1;
        File output = hasExtension ? file : type.addExtensionIfMissing(file);
        type.serialize(output, data);
        return output;
    }

    public static List<File> getFinalResourceDirs(File resourceDir, String environmentAsCommaSeparateStr) {
        ArrayList<File> resourceDirs = new ArrayList<File>();
        if (resourceDir != null && StringUtils.isNotBlank((CharSequence)environmentAsCommaSeparateStr)) {
            String[] environments;
            for (String environment : environments = environmentAsCommaSeparateStr.split(",")) {
                resourceDirs.add(new File(resourceDir, environment.trim()));
            }
        } else if (StringUtils.isBlank((CharSequence)environmentAsCommaSeparateStr)) {
            resourceDirs.add(resourceDir);
        }
        return resourceDirs;
    }
}

