/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class Serialization {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, true));
    private static final KubernetesSerialization KUBERNETES_SERIALIZATION = new KubernetesSerialization(JSON_MAPPER, true);

    private Serialization() {
    }

    public static <T> T unmarshal(String objectAsString) {
        return (T)Serialization.unmarshal(objectAsString, KubernetesResource.class);
    }

    public static <T> T unmarshal(URL url) throws IOException {
        return (T)Serialization.unmarshal(url, KubernetesResource.class);
    }

    public static <T> T unmarshal(File file) throws IOException {
        return (T)Serialization.unmarshal(file, KubernetesResource.class);
    }

    public static <T> T unmarshal(File file, Class<T> clazz) throws IOException {
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            T t = Serialization.unmarshal(fis, clazz);
            return t;
        }
    }

    public static <T> T unmarshal(File file, TypeReference<T> type) throws IOException {
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            T t = Serialization.unmarshal(fis, type);
            return t;
        }
    }

    public static <T> T unmarshal(URL url, Class<T> type) throws IOException {
        try (InputStream is = url.openStream();){
            T t = Serialization.unmarshal(is, type);
            return t;
        }
    }

    public static <T> T unmarshal(URL url, TypeReference<T> type) throws IOException {
        try (InputStream is = url.openStream();){
            T t = Serialization.unmarshal(is, type);
            return t;
        }
    }

    public static <T> T unmarshal(InputStream is, Class<T> clazz) {
        return (T)KUBERNETES_SERIALIZATION.unmarshal(is, clazz);
    }

    public static <T> T unmarshal(InputStream is, TypeReference<T> type) {
        return (T)KUBERNETES_SERIALIZATION.unmarshal(is, type);
    }

    public static <T> T unmarshal(String string, Class<T> type) {
        return (T)KUBERNETES_SERIALIZATION.unmarshal(string, type);
    }

    public static <T> T unmarshal(String string, TypeReference<T> type) {
        return Serialization.unmarshal((InputStream)new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)), type);
    }

    public static <T> T merge(T original, T overrides) throws IOException {
        ObjectReader reader = JSON_MAPPER.readerForUpdating(original);
        return (T)reader.readValue(Serialization.asJson(overrides));
    }

    public static <T> T convertValue(Object object, Class<T> type) {
        return (T)JSON_MAPPER.convertValue(object, type);
    }

    public static String asJson(Object object) {
        return KUBERNETES_SERIALIZATION.asJson(object);
    }

    public static String asYaml(Object object) {
        return KUBERNETES_SERIALIZATION.asYaml(object);
    }

    public static void saveJson(File resultFile, Object value) throws IOException {
        JSON_MAPPER.writeValue(resultFile, value);
    }

    public static void saveYaml(File resultFile, Object value) throws IOException {
        YAML_MAPPER.writeValue(resultFile, value);
    }

    static {
        for (ObjectMapper mapper : new ObjectMapper[]{JSON_MAPPER, YAML_MAPPER}) {
            mapper.enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS).disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        }
        YAML_MAPPER.registerModules(new Module[]{new JavaTimeModule(), KUBERNETES_SERIALIZATION.getUnmatchedFieldTypeModule()});
        KUBERNETES_SERIALIZATION.getUnmatchedFieldTypeModule().setRestrictToTemplates(false);
        KUBERNETES_SERIALIZATION.getUnmatchedFieldTypeModule().setLogWarnings(false);
    }
}

