/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.jkube.kit.common.KitLogger;

public class ArtifactUtil {
    private static final String LAST_MODIFIED_TIME_SAVE_FILENAME = ".jkube-last-modified";

    private ArtifactUtil() {
    }

    public static void warnStaleArtifact(KitLogger logger, File artifact) {
        if (artifact == null || artifact.isDirectory() || !artifact.exists()) {
            logger.warn("Final output artifact file was not detected. The project may have not been built. HINT: try to compile and package your application prior to running the container image build task.", new Object[0]);
            return;
        }
        Path lastModifiedMarker = artifact.getParentFile().toPath().resolve(LAST_MODIFIED_TIME_SAVE_FILENAME);
        try {
            if (lastModifiedMarker.toFile().exists() && Long.parseLong(new String(Files.readAllBytes(lastModifiedMarker))) == artifact.lastModified()) {
                logger.info("Final output artifact file was not rebuilt since last build. HINT: try to compile and package your application prior to running the container image build task.", new Object[0]);
            }
            Files.write(lastModifiedMarker, String.valueOf(artifact.lastModified()).getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

