/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AsyncUtil {
    private AsyncUtil() {
    }

    public static <T> CompletableFuture<T> async(ThrowingFunction<CompletableFuture<T>, T> function) {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                future.complete(function.apply(future));
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        }, ExecutorServiceHolder.INSTANCE);
        future.whenComplete((result, throwable) -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        return future;
    }

    public static <T> CompletableFuture<T> async(Callable<T> callable) {
        return AsyncUtil.async((CompletableFuture<T> f) -> callable.call());
    }

    public static <T> Function<Predicate<T>, CompletableFuture<T>> await(Supplier<T> supplier) {
        return predicate -> AsyncUtil.async(() -> AsyncUtil.lambda$null$3(predicate, (Supplier)supplier));
    }

    public static <T> T get(CompletableFuture<T> completableFuture, Duration duration) {
        try {
            return completableFuture.get(duration.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Failure while waiting to get future ", e);
        }
    }

    public static <T> T get(CompletableFuture<T> completableFuture) {
        try {
            return completableFuture.get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    private static /* synthetic */ Object lambda$null$3(Predicate predicate, Supplier supplier) throws Exception {
        Object ret;
        while (!predicate.test(ret = supplier.get())) {
            Thread.sleep(100L);
        }
        return ret;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    private static class ExecutorServiceHolder {
        public static final ExecutorService INSTANCE = Executors.newCachedThreadPool();

        private ExecutorServiceHolder() {
        }
    }
}

