/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.PluginServiceFactory;

public class ClassUtil {
    private static final FileFilter DIR_FILTER = pathname -> pathname.isDirectory() && !pathname.getName().startsWith(".");
    private static final FileFilter CLASS_FILE_FILTER = file -> file.isFile() && file.getName().endsWith(".class");

    private ClassUtil() {
    }

    public static Set<String> getResources(String resource) throws IOException {
        return ClassUtil.getResources(resource, null);
    }

    public static Set<String> getResources(String resource, List<ClassLoader> additionalClassLoaders) throws IOException {
        ClassLoader[] classLoaders = ClassUtil.mergeClassLoaders(additionalClassLoaders);
        HashSet<String> ret = new HashSet<String>();
        for (ClassLoader cl : classLoaders) {
            Enumeration<URL> urlEnum = cl.getResources(resource);
            ret.addAll(ClassUtil.extractUrlAsStringsFromEnumeration(urlEnum));
        }
        return ret;
    }

    private static ClassLoader[] mergeClassLoaders(List<ClassLoader> additionalClassLoaders) {
        ClassLoader[] classLoaders = additionalClassLoaders != null && !additionalClassLoaders.isEmpty() ? (ClassLoader[])ArrayUtils.addAll((Object[])ClassUtil.getClassLoaders(), (Object[])additionalClassLoaders.toArray(new ClassLoader[additionalClassLoaders.size()])) : ClassUtil.getClassLoaders();
        return classLoaders;
    }

    private static ClassLoader[] getClassLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader(), PluginServiceFactory.class.getClassLoader()};
    }

    private static Set<String> extractUrlAsStringsFromEnumeration(Enumeration<URL> urlEnum) {
        HashSet<String> ret = new HashSet<String>();
        while (urlEnum.hasMoreElements()) {
            ret.add(urlEnum.nextElement().toExternalForm());
        }
        return ret;
    }

    public static <T> Class<T> classForName(String className, List<ClassLoader> additionalClassLoaders) {
        ClassLoader[] classLoaders = ClassUtil.mergeClassLoaders(additionalClassLoaders);
        HashSet<ClassLoader> tried = new HashSet<ClassLoader>();
        ClassLoader[] classLoaderArray = classLoaders;
        int n = classLoaderArray.length;
        for (int i = 0; i < n; ++i) {
            for (ClassLoader loader = classLoaderArray[i]; loader != null; loader = loader.getParent()) {
                try {
                    if (!tried.contains(loader)) {
                        return Class.forName(className, true, loader);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                tried.add(loader);
            }
        }
        return null;
    }

    public static List<String> findMainClasses(File rootDir) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        if (!rootDir.exists()) {
            return ret;
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Path %s is not a directory", rootDir.getPath()));
        }
        ClassUtil.findClasses(ret, rootDir, rootDir.getAbsolutePath() + "/");
        return ret;
    }

    public static URLClassLoader createClassLoader(List<String> classpathElements, String ... paths) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            URL url = ClassUtil.pathToUrl(path);
            urls.add(url);
        }
        for (Object e : classpathElements) {
            if (e == null) continue;
            String path = e.toString();
            URL url = ClassUtil.pathToUrl(path);
            urls.add(url);
        }
        return ClassUtil.createURLClassLoader(urls);
    }

    private static URL pathToUrl(String path) {
        try {
            File file = new File(path);
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Cannot convert %s to a an URL: %s", path, e.getMessage()), e);
        }
    }

    private static URLClassLoader createURLClassLoader(Collection<URL> jars) {
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }

    private static void findClasses(List<String> classes, File dir, String prefix) throws IOException {
        for (File subDir : dir.listFiles(DIR_FILTER)) {
            ClassUtil.findClasses(classes, subDir, prefix);
        }
        for (File classFile : dir.listFiles(CLASS_FILE_FILTER)) {
            try (FileInputStream is = new FileInputStream(classFile);){
                if (!ClassUtil.hasMainMethod(is)) continue;
                classes.add(ClassUtil.convertToClass(classFile.getAbsolutePath(), prefix));
            }
        }
    }

    private static boolean hasMainMethod(InputStream is) throws IOException {
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass ctClass = pool.makeClass(is);
            CtClass stringClass = pool.get("java.lang.String[]");
            CtMethod mainMethod = ctClass.getDeclaredMethod("main", new CtClass[]{stringClass});
            return mainMethod.getReturnType() == CtClass.voidType && Modifier.isStatic((int)mainMethod.getModifiers()) && Modifier.isPublic((int)mainMethod.getModifiers());
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private static String convertToClass(String name, String prefix) {
        String ret = name.replaceAll("[/\\\\]", ".");
        ret = ret.substring(0, name.length() - ".class".length());
        return ret.substring(prefix.length());
    }

    public static URLClassLoader createProjectClassLoader(List<String> elements, KitLogger log) {
        try {
            ArrayList<URL> compileJars = new ArrayList<URL>();
            for (String element : elements) {
                compileJars.add(new File(element).toURI().toURL());
            }
            return new URLClassLoader(compileJars.toArray(new URL[compileJars.size()]), PluginServiceFactory.class.getClassLoader());
        }
        catch (Exception e) {
            log.warn("Instructed to use project classpath, but cannot. Continuing build if we can: ", e);
            return new URLClassLoader(new URL[0]);
        }
    }
}

