/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.io.IOException;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitUtil {
    private GitUtil() {
    }

    public static Repository getGitRepository(File currentDir) throws IOException {
        File gitFolder;
        if (currentDir == null) {
            currentDir = new File(System.getProperty("basedir", "."));
        }
        if ((gitFolder = GitUtil.findGitFolder(currentDir)) == null) {
            return null;
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        return ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).setGitDir(gitFolder)).build();
    }

    public static File findGitFolder(File basedir) {
        File gitDir = new File(basedir, ".git");
        if (gitDir.exists() && gitDir.isDirectory()) {
            return gitDir;
        }
        File parent = basedir.getParentFile();
        if (parent != null) {
            return GitUtil.findGitFolder(parent);
        }
        return null;
    }

    public static String getGitCommitId(Repository repository) throws GitAPIException {
        if (repository != null) {
            return StreamSupport.stream(new Git(repository).log().call().spliterator(), false).map(AnyObjectId::getName).findFirst().orElse(null);
        }
        return null;
    }
}

