/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util.okhttp;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.kit.common.util.okhttp.BufferStringReader;

public class HttpHeaders {
    private static final int MARK_LIMIT = Integer.MAX_VALUE;
    private static final List<Character> QUOTED_STRING_DELIMITERS = Arrays.asList(Character.valueOf('\\'), Character.valueOf('\"'));
    private static final List<Character> TOKEN_DELIMITERS = Arrays.asList(Character.valueOf('\t'), Character.valueOf(' '), Character.valueOf(','), Character.valueOf('='));

    private HttpHeaders() {
    }

    public static List<Map<String, String>> parseWwwAuthenticateChallengeHeaders(String header) throws IOException {
        String peek = null;
        ArrayList<Map<String, String>> challenges = new ArrayList<Map<String, String>>();
        BufferStringReader stringReader = new BufferStringReader(header);
        while (true) {
            LinkedHashMap<String, String> parameters;
            String schemeName;
            block11: {
                if (peek == null) {
                    HttpHeaders.skipWhitespaceAndCommas(stringReader);
                    peek = HttpHeaders.readToken(stringReader);
                    if (peek == null) {
                        return challenges;
                    }
                }
                schemeName = peek;
                boolean commaPrefixed = HttpHeaders.skipWhitespaceAndCommas(stringReader);
                peek = HttpHeaders.readToken(stringReader);
                if (peek == null) {
                    if (!stringReader.exhausted()) {
                        return challenges;
                    }
                    challenges.add(HttpHeaders.createNewChallenge(schemeName, Collections.emptyMap()));
                    return challenges;
                }
                int eqCount = HttpHeaders.skipAll(stringReader, '=');
                boolean commaSuffixed = HttpHeaders.skipWhitespaceAndCommas(stringReader);
                if (!commaPrefixed && (commaSuffixed || stringReader.exhausted())) {
                    challenges.add(HttpHeaders.createNewChallenge(schemeName, Collections.singletonMap(null, peek + HttpHeaders.repeat('=', eqCount))));
                    peek = null;
                    continue;
                }
                parameters = new LinkedHashMap<String, String>();
                eqCount += HttpHeaders.skipAll(stringReader, '=');
                do {
                    String parameterValue;
                    if (peek == null) {
                        peek = HttpHeaders.readToken(stringReader);
                        if (HttpHeaders.skipWhitespaceAndCommas(stringReader)) break block11;
                        eqCount = HttpHeaders.skipAll(stringReader, '=');
                    }
                    if (eqCount == 0) break block11;
                    if (eqCount > 1) {
                        return challenges;
                    }
                    if (HttpHeaders.skipWhitespaceAndCommas(stringReader)) {
                        return challenges;
                    }
                    String string = parameterValue = !stringReader.exhausted() && stringReader.getByte(0L) == '\"' ? HttpHeaders.readQuotedString(stringReader) : HttpHeaders.readToken(stringReader);
                    if (parameterValue == null) {
                        return challenges;
                    }
                    String replaced = parameters.put(peek, parameterValue);
                    peek = null;
                    if (replaced == null) continue;
                    return challenges;
                } while (HttpHeaders.skipWhitespaceAndCommas(stringReader) || stringReader.exhausted());
                return challenges;
            }
            challenges.add(HttpHeaders.createNewChallenge(schemeName, parameters));
        }
    }

    private static Map<String, String> createNewChallenge(String scheme, Map<String, String> authParams) {
        HashMap<String, String> challengeAsMap = new HashMap<String, String>();
        challengeAsMap.put("scheme", scheme);
        challengeAsMap.putAll(authParams);
        return challengeAsMap;
    }

    private static boolean skipWhitespaceAndCommas(StringReader buffer) throws IOException {
        boolean commaFound = false;
        int charRead = 0;
        while (charRead != -1) {
            buffer.mark(Integer.MAX_VALUE);
            charRead = buffer.read();
            char b = (char)charRead;
            if (b == ',' || b == ' ' || b == '\t') {
                if (b != ',') continue;
                commaFound = true;
                continue;
            }
            if (charRead == -1) continue;
            buffer.reset();
            break;
        }
        return commaFound;
    }

    private static int skipAll(BufferStringReader buffer, char b) throws IOException {
        char curChar;
        int charRead;
        int count = 0;
        do {
            buffer.mark(Integer.MAX_VALUE);
            charRead = buffer.read();
            curChar = (char)charRead;
            if (charRead != -1 && curChar == b) {
                ++count;
                continue;
            }
            if (curChar == b) continue;
            buffer.reset();
        } while (charRead != -1 && curChar == b);
        return count;
    }

    private static String readQuotedString(BufferStringReader buffer) throws IOException {
        if (buffer.readByte() != '\"') {
            throw new IllegalArgumentException();
        }
        StringBuilder result = new StringBuilder();
        long i;
        while ((i = (long)buffer.indexOfElement(QUOTED_STRING_DELIMITERS)) != -1L) {
            if (buffer.getByte(i) == '\"') {
                String quoteString = buffer.readUtf8(i);
                result.append(quoteString);
                buffer.readByte();
                return result.toString();
            }
            if ((long)buffer.size() == i + 1L) {
                return null;
            }
            result.append(buffer.readUtf8(i));
            buffer.readByte();
            result.append(buffer.readUtf8(1L));
        }
        return null;
    }

    private static String readToken(BufferStringReader buffer) {
        try {
            long tokenSize = buffer.indexOfElement(TOKEN_DELIMITERS);
            if (tokenSize == -1L) {
                tokenSize = buffer.size();
            }
            return tokenSize != 0L ? buffer.readUtf8(tokenSize) : null;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    private static String repeat(char c, int count) {
        char[] array = new char[count];
        Arrays.fill(array, c);
        return new String(array);
    }
}

